/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.monitor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JPanel;
import rcssjava.VecPosition;
import rcssjava.monitor.FieldShape;
import rcssjava.monitor.Monitor;
import rcssjava.monitor.MonitorParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldCanvas
extends JPanel {
    final double TOTAL_X = 115.0;
    final double TOTAL_Y = 82.0;
    private JFrame frame;
    private Monitor monitor;
    private Image offscreenImage;
    private Graphics2D offscreenBuffer;
    private Dimension canvasSize;

    public FieldCanvas(JFrame jFrame, Monitor monitor) {
        this.frame = jFrame;
        this.monitor = monitor;
    }

    public void updateCanvasSize() {
        Dimension dimension = this.getSize();
        if (this.canvasSize == null || !this.canvasSize.equals(dimension)) {
            this.canvasSize = dimension;
            this.offscreenImage = this.frame.createImage(this.canvasSize.width, this.canvasSize.height);
            this.offscreenBuffer = (Graphics2D)this.offscreenImage.getGraphics();
        }
    }

    public void drawField(MonitorParams monitorParams) {
        double d = 52.5;
        double d2 = 34.0;
        double d3 = d - 16.5;
        double d4 = 20.16;
        double d5 = d - 5.5;
        double d6 = 9.16;
        double d7 = d + 2.44;
        double d8 = 7.069999999999999;
        this.offscreenBuffer.setBackground(monitorParams.color_field);
        this.offscreenBuffer.clearRect(0, 0, this.canvasSize.width, this.canvasSize.height);
        this.drawRect(new VecPosition(-d, -d8), new VecPosition(-d7, d8), Color.BLACK, true);
        this.drawRect(new VecPosition(d, -d8), new VecPosition(d7, d8), Color.BLACK, true);
        this.drawCircle(new VecPosition(-d + 11.0, 0.0), monitorParams.penalty_spot_radius, Color.WHITE, true);
        this.drawCircle(new VecPosition(d - 11.0, 0.0), monitorParams.penalty_spot_radius, Color.WHITE, true);
        this.drawRect(new VecPosition(-d, -d2), new VecPosition(d, d2), Color.WHITE, false);
        if (monitorParams.show_middle_line) {
            this.drawLine(new VecPosition(0.0, -d2), new VecPosition(0.0, d2), Color.WHITE);
        }
        this.drawLine(new VecPosition(-d, -d4), new VecPosition(-d3, -d4), Color.WHITE);
        this.drawLine(new VecPosition(-d3, -d4), new VecPosition(-d3, d4), Color.WHITE);
        this.drawLine(new VecPosition(-d3, d4), new VecPosition(-d, d4), Color.WHITE);
        this.drawLine(new VecPosition(-d, -d6), new VecPosition(-d5, -d6), Color.WHITE);
        this.drawLine(new VecPosition(-d5, -d6), new VecPosition(-d5, d6), Color.WHITE);
        this.drawLine(new VecPosition(-d5, d6), new VecPosition(-d, d6), Color.WHITE);
        this.drawLine(new VecPosition(d, -d4), new VecPosition(d3, -d4), Color.WHITE);
        this.drawLine(new VecPosition(d3, -d4), new VecPosition(d3, d4), Color.WHITE);
        this.drawLine(new VecPosition(d3, d4), new VecPosition(d, d4), Color.WHITE);
        this.drawLine(new VecPosition(d, -d6), new VecPosition(d5, -d6), Color.WHITE);
        this.drawLine(new VecPosition(d5, -d6), new VecPosition(d5, d6), Color.WHITE);
        this.drawLine(new VecPosition(d5, d6), new VecPosition(d, d6), Color.WHITE);
        if (monitorParams.show_center_circle) {
            this.drawCircle(new VecPosition(0.0, 0.0), 9.15, Color.WHITE, false);
        }
        this.drawArc(new VecPosition(-d, -d2), monitorParams.corner_arc_radius, 270, 90, Color.WHITE);
        this.drawArc(new VecPosition(d, -d2), monitorParams.corner_arc_radius, 180, 90, Color.WHITE);
        this.drawArc(new VecPosition(d, d2), monitorParams.corner_arc_radius, 90, 90, Color.WHITE);
        this.drawArc(new VecPosition(-d, d2), monitorParams.corner_arc_radius, 0, 90, Color.WHITE);
    }

    public void drawShapes(Collection<FieldShape> collection) {
        for (FieldShape fieldShape : collection) {
            fieldShape.draw(this);
        }
    }

    public Color getColorFromHex(String string) {
        return new Color(Integer.decode("0x" + string));
    }

    public void drawRect(VecPosition vecPosition, VecPosition vecPosition2, Color color, boolean bl) {
        VecPosition vecPosition3 = this.fieldToCanvas(vecPosition);
        int n = (int)Math.round(vecPosition3.getX());
        int n2 = (int)Math.round(vecPosition3.getY());
        VecPosition vecPosition4 = this.fieldToCanvas(vecPosition2);
        int n3 = (int)Math.round(vecPosition4.getX());
        int n4 = (int)Math.round(vecPosition4.getY());
        int n5 = Math.min(n, n3);
        int n6 = Math.min(n2, n4);
        int n7 = Math.abs(n - n3);
        int n8 = Math.abs(n2 - n4);
        this.offscreenBuffer.setPaint(color);
        if (bl) {
            this.offscreenBuffer.fillRect(n5, n6, n7, n8);
        } else {
            this.offscreenBuffer.drawRect(n5, n6, n7, n8);
        }
    }

    public void drawText(VecPosition vecPosition, String string, Color color) {
        VecPosition vecPosition2 = this.fieldToCanvas(vecPosition);
        int n = (int)Math.round(vecPosition2.getX());
        int n2 = (int)Math.round(vecPosition2.getY());
        this.offscreenBuffer.setFont(new Font("Arial", 1, 16));
        this.offscreenBuffer.setPaint(color);
        this.offscreenBuffer.drawString(string, n, n2);
    }

    public void drawLine(VecPosition vecPosition, VecPosition vecPosition2, Color color) {
        VecPosition vecPosition3 = this.fieldToCanvas(vecPosition);
        int n = (int)Math.round(vecPosition3.getX());
        int n2 = (int)Math.round(vecPosition3.getY());
        VecPosition vecPosition4 = this.fieldToCanvas(vecPosition2);
        int n3 = (int)Math.round(vecPosition4.getX());
        int n4 = (int)Math.round(vecPosition4.getY());
        this.offscreenBuffer.setPaint(color);
        this.offscreenBuffer.drawLine(n, n2, n3, n4);
    }

    public void drawArc(VecPosition vecPosition, double d, int n, int n2, Color color) {
        VecPosition vecPosition2 = this.fieldToCanvas(vecPosition);
        int n3 = (int)Math.round(vecPosition2.getX());
        int n4 = (int)Math.round(vecPosition2.getY());
        int n5 = (int)Math.round(this.fieldToCanvas(d));
        this.offscreenBuffer.setPaint(color);
        this.offscreenBuffer.drawArc(n3 - n5, n4 - n5, 2 * n5, 2 * n5, n, n2);
    }

    public void drawCircle(VecPosition vecPosition, double d, Color color, boolean bl) {
        VecPosition vecPosition2 = this.fieldToCanvas(vecPosition);
        int n = (int)Math.round(vecPosition2.getX());
        int n2 = (int)Math.round(vecPosition2.getY());
        int n3 = (int)Math.round(this.fieldToCanvas(d));
        this.offscreenBuffer.setPaint(color);
        if (bl) {
            this.offscreenBuffer.fillOval(n - n3, n2 - n3, 2 * n3, 2 * n3);
        } else {
            this.offscreenBuffer.drawOval(n - n3, n2 - n3, 2 * n3, 2 * n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.offscreenImage != null) {
            graphics.drawImage(this.offscreenImage, 0, 0, this);
        }
    }

    private VecPosition canvasToField(VecPosition vecPosition) {
        double d = vecPosition.getX() * 115.0 / (double)this.canvasSize.width - 57.5;
        double d2 = vecPosition.getY() * 82.0 / (double)this.canvasSize.height - 41.0;
        return new VecPosition(d, d2);
    }

    private VecPosition fieldToCanvas(VecPosition vecPosition) {
        double d = vecPosition.getX() * (double)this.canvasSize.width / 115.0 + (double)(this.canvasSize.width / 2);
        double d2 = vecPosition.getY() * (double)this.canvasSize.height / 82.0 + (double)(this.canvasSize.height / 2);
        return new VecPosition(d, d2);
    }

    private double canvasToField(double d) {
        return d * 115.0 / (double)this.canvasSize.width;
    }

    private double fieldToCanvas(double d) {
        return d * (double)this.canvasSize.width / 115.0;
    }
}

