/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.monitor;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import rcssjava.ServerParams;
import rcssjava.Utils;
import rcssjava.VecPosition;
import rcssjava.WorldState;
import rcssjava.monitor.FieldCanvas;
import rcssjava.monitor.FieldCircle;
import rcssjava.monitor.FieldLine;
import rcssjava.monitor.FieldShape;
import rcssjava.monitor.FieldText;
import rcssjava.monitor.MonitorListener;
import rcssjava.monitor.MonitorParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Monitor {
    private MonitorParams MP;
    private ServerParams SP;
    private MonitorListener listener;
    private FieldCanvas field;
    private JFrame frame;

    public Monitor() {
        this(null);
    }

    public Monitor(MonitorParams monitorParams) {
        this(monitorParams, null);
    }

    public Monitor(MonitorParams monitorParams, ServerParams serverParams) {
        this(monitorParams, serverParams, null);
    }

    public Monitor(MonitorParams monitorParams, ServerParams serverParams, MonitorListener monitorListener) {
        this.MP = monitorParams == null ? new MonitorParams() : monitorParams;
        this.SP = serverParams == null ? new ServerParams() : serverParams;
        this.listener = monitorListener == null ? new MonitorListener(this) : monitorListener;
        this.initializeFrame();
    }

    private void createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setOpaque(true);
        this.createFileMenu(jMenuBar);
        this.frame.setJMenuBar(jMenuBar);
    }

    private void createFileMenu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenu.getAccessibleContext().setAccessibleDescription("The File Menu");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Quit", 81);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        jMenuItem.getAccessibleContext().setAccessibleDescription("Quit the program");
        jMenuItem.addActionListener(this.listener);
        jMenu.add(jMenuItem);
    }

    private void initializeFrame() {
        JFrame.setDefaultLookAndFeelDecorated(false);
        this.frame = new JFrame(this.MP.title);
        this.frame.setDefaultCloseOperation(3);
        this.createMenuBar();
        this.field = new FieldCanvas(this.frame, this);
        this.field.setPreferredSize(new Dimension(this.MP.window_size_x, this.MP.window_size_y));
        this.field.addMouseListener(this.listener);
        this.field.addMouseMotionListener(this.listener);
        this.frame.getContentPane().add(this.field);
        this.field.setVisible(true);
        this.frame.pack();
        this.frame.addWindowStateListener(this.listener);
        this.frame.setVisible(true);
        this.update(null);
    }

    private Vector<FieldShape> getBallShape(WorldState worldState) {
        Vector<FieldShape> vector = new Vector<FieldShape>();
        double d = 1.3;
        vector.add(new FieldCircle(this.MP.color_ball, true, worldState.getBallPosition(), this.MP.ball_radius, this.MP.depth_ball));
        vector.add(new FieldCircle(this.MP.color_ball, false, worldState.getBallPosition(), d, this.MP.depth_ball));
        return vector;
    }

    private Vector<FieldShape> getPlayerShape(WorldState worldState, int n) {
        Vector<FieldShape> vector = new Vector<FieldShape>();
        if (!worldState.isOnSidelines(n) || this.MP.show_sideline_players) {
            VecPosition vecPosition = worldState.getPlayerPosition(n);
            double d = 1.1;
            double d2 = 0.3;
            Color color = Utils.isLeftPlayer(n) ? this.MP.color_team_l : this.MP.color_team_r;
            Color color2 = Utils.isLeftPlayer(n) ? this.MP.color_unum_l : this.MP.color_unum_r;
            vector.add(new FieldCircle(color, true, vecPosition, d, this.MP.depth_player_body));
            vector.add(new FieldCircle(this.MP.color_player_outline, false, vecPosition, d, this.MP.depth_player_outline));
            vector.add(new FieldCircle(this.MP.color_player_outline, false, vecPosition, d2, this.MP.depth_player_outline));
            VecPosition vecPosition2 = new VecPosition(d, worldState.getPlayerBodyAngle(n), true);
            VecPosition vecPosition3 = new VecPosition(d, worldState.getPlayerNeckAngle(n) + worldState.getPlayerBodyAngle(n), true);
            vector.add(new FieldLine(this.MP.color_body_ang, vecPosition, vecPosition.add(vecPosition2), this.MP.depth_player_decorations));
            vector.add(new FieldLine(this.MP.color_neck_ang, vecPosition, vecPosition.add(vecPosition3), this.MP.depth_player_decorations));
            vector.add(new FieldText(color2, vecPosition, Utils.getUnumFromID(n) + "", this.MP.depth_player_unum));
        }
        return vector;
    }

    private Vector<FieldShape> getWorldStateShapes(WorldState worldState) {
        Vector<FieldShape> vector = new Vector<FieldShape>();
        if (worldState != null) {
            if (this.MP.show_ball) {
                vector.addAll(this.getBallShape(worldState));
            }
            if (this.MP.show_players) {
                for (int i = 0; i < 22; ++i) {
                    vector.addAll(this.getPlayerShape(worldState, i));
                }
            }
        }
        return vector;
    }

    public void update(WorldState worldState) {
        this.update(worldState, null);
    }

    public void update(WorldState worldState, Vector<FieldShape> vector) {
        Vector<FieldShape> vector2 = this.getWorldStateShapes(worldState);
        if (vector != null) {
            vector2.addAll(vector);
        }
        Collections.sort(vector2);
        this.field.updateCanvasSize();
        this.field.drawField(this.MP);
        this.field.drawShapes(vector2);
        this.repaint();
    }

    public void repaint() {
        this.field.repaint();
    }

    public void quit() {
        System.exit(0);
    }
}

