/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.trainer;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import rcssjava.ServerParams;
import rcssjava.Utils;
import rcssjava.VecPosition;
import rcssjava.WorldState;
import rcssjava.comm.TrainerCommandHandler;
import rcssjava.geom.Rectangle;
import rcssjava.monitor.FieldRect;
import rcssjava.monitor.FieldShape;
import rcssjava.monitor.Monitor;
import rcssjava.monitor.MonitorParams;
import rcssjava.trainer.Task;

public class KeepawayTask
implements Task {
    final String trainingMsg = "ka ";
    final int TURNOVER_TIME = 4;
    ServerParams SP;
    WorldState WS;
    TrainerCommandHandler CMD;
    int numKeepers;
    int numTakers;
    double kawayWidth;
    double kawayLength;
    BufferedWriter bw;
    int epoch;
    Random rand;
    Rectangle region;
    int takeTime;
    int startTime;
    Monitor monitor;
    Vector<FieldShape> shapes;
    Set<Integer> keepers;
    Set<Integer> takers;
    Set<Integer> players;

    public KeepawayTask(ServerParams serverParams, WorldState worldState, TrainerCommandHandler trainerCommandHandler, boolean bl, int n, int n2, double d, double d2, String string) {
        int n3;
        this.SP = serverParams;
        this.WS = worldState;
        this.CMD = trainerCommandHandler;
        this.numKeepers = n;
        this.numTakers = n2;
        this.kawayWidth = d;
        this.kawayLength = d2;
        if (string != null) {
            try {
                this.bw = new BufferedWriter(new FileWriter(string));
            }
            catch (Exception exception) {
                System.err.println("Unable to create .kwy file: " + exception);
                this.bw = null;
            }
        }
        this.epoch = 0;
        this.rand = new Random();
        this.region = new Rectangle(d, d2);
        this.takeTime = 0;
        this.keepers = new HashSet<Integer>();
        for (n3 = 1; n3 <= n; ++n3) {
            this.keepers.add(Utils.getPlayerID(0, n3));
        }
        this.takers = new HashSet<Integer>();
        for (n3 = 1; n3 <= n2; ++n3) {
            this.takers.add(Utils.getPlayerID(1, n3));
        }
        this.players = new HashSet<Integer>();
        this.players.addAll(this.keepers);
        this.players.addAll(this.takers);
        this.monitor = null;
        this.shapes = null;
        if (bl) {
            MonitorParams monitorParams = new MonitorParams();
            monitorParams.show_center_circle = false;
            monitorParams.show_middle_line = false;
            this.monitor = new Monitor(monitorParams, serverParams);
            this.shapes = new Vector();
            this.shapes.add(new FieldRect(Color.WHITE, false, this.region.getTopLeft(), this.region.getBottomRight(), 0));
        }
    }

    public void init() {
        if (this.bw != null) {
            this.kwyHeader();
        }
        this.resetField();
        this.CMD.changeMode(3);
    }

    public boolean processCycle() {
        if (this.monitor != null) {
            this.monitor.update(this.WS, this.shapes);
        }
        if (!this.region.isInside(this.WS.getBallPosition())) {
            if (this.bw != null) {
                this.kwyLogEpisode('o');
            }
            this.resetField();
        } else if (this.takeTime >= 4) {
            if (this.bw != null) {
                this.kwyLogEpisode('t');
            }
            this.resetField();
        } else {
            int n;
            int n2;
            boolean bl = false;
            for (n2 = 1; n2 <= this.numKeepers; ++n2) {
                n = Utils.getLeftPlayerID(n2);
                if (!this.WS.isBallKickableBy(n)) continue;
                bl = true;
                break;
            }
            n2 = 0;
            for (n = 1; n <= this.numTakers; ++n) {
                int n3 = Utils.getRightPlayerID(n);
                if (!this.WS.isBallKickableBy(n3)) continue;
                n2 = 1;
                break;
            }
            this.takeTime = n2 != 0 && !bl ? ++this.takeTime : 0;
        }
        for (int n2 : this.players) {
            if (this.WS.getTimeSinceSeenPlayer(n2) <= 50) continue;
            System.err.println("Haven't seen player " + n2 + " in over 50 cycles.");
            return false;
        }
        if (this.WS.getTime() - this.startTime > 1050) {
            System.err.println("Episode lasted longer than 1:45-- that can't be right.");
            return false;
        }
        return true;
    }

    private void resetField() {
        VecPosition vecPosition;
        int n;
        double d = 2.0;
        double d2 = 4.0;
        int n2 = this.rand.nextInt(this.numKeepers);
        this.region = new Rectangle(this.region.getWidth(), this.region.getLength());
        if (this.shapes != null) {
            this.shapes.clear();
            this.shapes.add(new FieldRect(Color.WHITE, false, this.region.getTopLeft(), this.region.getBottomRight(), 0));
        }
        for (n = 1; n <= this.numKeepers; ++n) {
            switch (n2) {
                case 0: {
                    vecPosition = this.region.getBottomLeft().add(d);
                    break;
                }
                case 1: {
                    vecPosition = this.region.getTopLeft().add(new VecPosition(-d, d));
                    break;
                }
                case 2: {
                    vecPosition = this.region.getTopRight().subtract(d);
                    break;
                }
                default: {
                    vecPosition = this.region.getCenter().add(this.rand.nextGaussian());
                }
            }
            this.CMD.move(Utils.getLeftPlayerID(n), vecPosition);
            n2 = (n2 + 1) % this.numKeepers;
        }
        for (n = 1; n <= this.numTakers; ++n) {
            vecPosition = this.region.getBottomRight().add(new VecPosition(d, -d));
            vecPosition = vecPosition.add(this.rand.nextGaussian());
            this.CMD.move(Utils.getRightPlayerID(n), vecPosition);
        }
        vecPosition = this.region.getBottomLeft().add(d2);
        this.CMD.move(22, vecPosition, new VecPosition(0.0, 0.0));
        this.takeTime = 0;
        this.startTime = this.WS.getTime();
        ++this.epoch;
        this.CMD.say("ka ");
    }

    private void kwyHeader() {
        try {
            this.bw.write("# Keepers: " + this.numKeepers + "\n" + "# Takers:  " + this.numTakers + "\n" + "# Region:  " + this.kawayLength + " x " + this.kawayWidth + "\n");
            this.bw.write("#\n");
            this.bw.write("# Description of Fields:\n# 1) Episode number\n# 2) Start time in simulator steps (100ms)\n# 3) End time in simulator steps (100ms)\n# 4) Duration in simulator steps (100ms)\n# 5) (o)ut of bounds / (t)aken away\n");
            this.bw.write("#\n");
            this.bw.flush();
        }
        catch (Exception exception) {
            System.err.println("Unable to write to kwy file: " + exception);
        }
    }

    private void kwyLogEpisode(char c) {
        try {
            this.bw.write(this.epoch + "\t" + this.startTime + "\t" + this.WS.getTime() + "\t" + (this.WS.getTime() - this.startTime) + "\t" + c + "\n");
            this.bw.flush();
        }
        catch (Exception exception) {
            System.err.println("Unable to write to kwy file: " + exception);
        }
    }
}

