/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.trainer;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import rcssjava.ServerParams;
import rcssjava.WorldState;
import rcssjava.comm.Connection;
import rcssjava.comm.RCSSParser;
import rcssjava.comm.TrainerCommandHandler;
import rcssjava.trainer.KeepawayTask;
import rcssjava.trainer.Task;

public class Trainer {
    final int queueCapacity = 1100;
    ServerParams SP;
    WorldState WS;
    TrainerCommandHandler CMD;
    Connection C;
    RCSSParser parser;
    String queueFile;
    Task task;
    LinkedList<WorldState> cycleQueue;

    Trainer(ServerParams serverParams, WorldState worldState, Connection connection, TrainerCommandHandler trainerCommandHandler, RCSSParser rCSSParser, String string, Task task) {
        this.SP = serverParams;
        this.WS = worldState;
        this.C = connection;
        this.CMD = trainerCommandHandler;
        this.parser = rCSSParser;
        this.queueFile = string;
        this.task = task;
        this.cycleQueue = new LinkedList();
    }

    private void saveCycle() {
        WorldState worldState = new WorldState(this.SP);
        worldState.copy(this.WS);
        this.cycleQueue.addLast(worldState);
        if (this.cycleQueue.size() > 1100) {
            this.cycleQueue.removeFirst();
        }
    }

    private void writeCycles() {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.queueFile));
            objectOutputStream.writeObject(this.cycleQueue);
        }
        catch (Exception exception) {
            System.err.println("Unable to write World State queue: " + exception);
        }
    }

    private void mainLoop() {
        this.CMD.init(9.0);
        String string = this.C.receive();
        if (!string.equals("(init ok)")) {
            System.err.println("Unable to init: " + string);
            System.exit(1);
        }
        this.CMD.eye(true);
        int n = 0;
        boolean bl = true;
        do {
            string = this.C.receive();
            this.parser.analyzeMessage(string);
            if (bl && !this.WS.getLeftTeamName().equals("")) {
                bl = false;
                this.task.init();
            }
            if (this.WS.getTime() <= n) continue;
            n = this.WS.getTime();
            this.saveCycle();
            if (!this.task.processCycle()) {
                if (this.queueFile != null) {
                    this.writeCycles();
                }
                System.exit(1);
            }
            if (this.SP.synch_mode != 1) continue;
            this.CMD.done();
        } while (this.WS.getPlayMode() != 2);
        this.C.disconnect();
        System.out.println("Shutting down trainer.");
    }

    private static void printUsage() {
        System.out.println("RCSSJava Trainer\n");
        System.out.println("Commandline options:");
        System.out.println("-help                  - Print this usage message");
        System.out.println("-host <hostname>       - Host name or IP of Soccer Server");
        System.out.println("-port <int>            - UDP port on host to connect to");
        System.out.println("-keepers <int>         - Number of keepers");
        System.out.println("-takers <int>          - Number of takers");
        System.out.println("-width <size in m>     - Width of play region");
        System.out.println("-length <size in m>    - Length of play region");
        System.out.println("-kwy <filename>        - Save episode durations to logfile");
        System.out.println("-queue_file <filename> - Save cycles to queue file");
        System.out.println("-monitor <0/1>         - Set to 1 to launch monitor");
    }

    public static void main(String[] stringArray) {
        String string = "localhost";
        int n = 5801;
        boolean bl = false;
        String string2 = null;
        int n2 = 3;
        int n3 = 2;
        double d = 20.0;
        double d2 = 20.0;
        String string3 = null;
        try {
            for (int i = 0; i < stringArray.length; i += 2) {
                if (stringArray[i].equals("-help")) {
                    Trainer.printUsage();
                    System.exit(0);
                    continue;
                }
                if (stringArray[i].equals("-host")) {
                    string = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equals("-port")) {
                    n = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-monitor")) {
                    bl = stringArray[i + 1].equals("1");
                    continue;
                }
                if (stringArray[i].equals("-queue_file")) {
                    string2 = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equals("-keepers")) {
                    n2 = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-takers")) {
                    n3 = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-width")) {
                    d = Double.parseDouble(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-length")) {
                    d2 = Double.parseDouble(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-kwy")) {
                    string3 = stringArray[i + 1];
                    continue;
                }
                System.err.println("Unknown option: " + stringArray[i]);
            }
        }
        catch (Exception exception) {
            System.err.println("Unable to parse commandline options: " + exception);
            System.exit(1);
        }
        ServerParams serverParams = new ServerParams();
        WorldState worldState = new WorldState(serverParams);
        Connection connection = new Connection(string, n);
        TrainerCommandHandler trainerCommandHandler = new TrainerCommandHandler(connection, worldState);
        RCSSParser rCSSParser = new RCSSParser(worldState, serverParams);
        KeepawayTask keepawayTask = new KeepawayTask(serverParams, worldState, trainerCommandHandler, bl, n2, n3, d, d2, string3);
        Trainer trainer = new Trainer(serverParams, worldState, connection, trainerCommandHandler, rCSSParser, string2, keepawayTask);
        trainer.mainLoop();
    }
}

