#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <resolv.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>
#include <sys/time.h>
#include <unistd.h>
#include <assert.h>
#include "nfs.h"

void fw_relay(struct sockaddr_in s, struct sockaddr_in u, struct sockaddr_in d);

int main (int argc, char *argv[]) 
{
	struct sockaddr_in self;
	struct sockaddr_in u;
	struct sockaddr_in d;
	bzero((char *)&self, sizeof(self));
	bzero((char *)&u, sizeof(u));
	bzero((char *)&d, sizeof(d));

	
	self.sin_family = AF_INET;
	u.sin_family = AF_INET;
	d.sin_family = AF_INET;
	self.sin_port = u.sin_port = d.sin_port 
		= htons(NFSD_PROXY_PORT);

	int opt;
	while ((opt = getopt(argc, argv, "s:u:d:p:")) != EOF) {
		switch (opt) {
		case 's':
			self.sin_addr.s_addr = inet_addr(optarg);
			break;
		case 'u':
			u.sin_addr.s_addr = inet_addr(optarg);
			break;
		case 'd':
			d.sin_addr.s_addr = inet_addr(optarg);
			break;	
		case 'p':
			self.sin_port = u.sin_port = d.sin_port  
				= htons(atoi(optarg));
			break;
		}
	}
	
	fw_relay(self, u, d); 
}

void fw_relay(struct sockaddr_in self, struct sockaddr_in u, struct sockaddr_in d)
{
	int sock=socket(AF_INET, SOCK_DGRAM, 0);
	assert(sock>0);
	int ret = bind(sock, (struct sockaddr *)&self, sizeof(self));
	assert(ret == 0);
	fprintf(stderr, "Bind: %s:%d", inet_ntoa(self.sin_addr), ntohs(self.sin_port));

	const int max_msglen=100000;
	char msg[max_msglen];
	sockaddr_in from;
	bzero((char *)&from, sizeof(from));
	socklen_t from_len=sizeof(from);
	int msglen = recvfrom(sock, msg, max_msglen, 0, 
			      (struct sockaddr*)&from, &from_len);
	if (msglen<0)
		perror("\nRecv Request: ");
	else{
		//		assert(from.sin_addr.s_addr == d.sin_addr.s_addr);
		msg[msglen] = '\0';
		fprintf(stderr, "\nRecv Request: from: %s:%d", 
				//  msg, 
			inet_ntoa(from.sin_addr), ntohs(from.sin_port));
	}
	
	ret =sendto(sock, msg, msglen, 0, (struct sockaddr*)&u, sizeof(u));
	if (ret!=msglen)
		perror("\nSend Request: ");
	

	while (1){
		struct sockaddr_in addr;
		socklen_t addrlen=sizeof(addr);
		int msglen = recvfrom(sock, msg, max_msglen, 0, 
				      (struct sockaddr*)&addr, &addrlen);
		if (msglen<0)
			perror("\nRecv Message: ");
		else{
			msg[msglen] = '\0';
			if (from.sin_addr.s_addr == addr.sin_addr.s_addr){
				assert(addr.sin_port == from.sin_port);
				fprintf(stderr, "\nRecv Request: from: %s:%d", 
				        //  msg, 
					inet_ntoa(addr.sin_addr), ntohs(addr.sin_port));      
				ret =sendto(sock, msg, msglen, 0, (struct sockaddr*)&u, sizeof(u));
				if (ret!=msglen)
					perror("\nRelay Request: ");

			} 
			else{
				assert(addr.sin_addr.s_addr == u.sin_addr.s_addr);
				assert(addr.sin_port == u.sin_port);
				fprintf(stderr, "\nRecv Reply: from: %s:%d", 
				        //  msg, 
					inet_ntoa(addr.sin_addr), ntohs(addr.sin_port));  
				ret =sendto(sock, msg, msglen, 0, (struct sockaddr*)&from, sizeof(from));
				if (ret!=msglen)
					perror("\nRelay Reply: ");
			}			
		}
	
	}
}

