#include<stdio.h>
#include<pthread.h>
#include<stdlib.h>
#include <unistd.h>


pthread_mutex_t req_queue_mutex = PTHREAD_MUTEX_INITIALIZER ;
pthread_cond_t req_ready_cond =  PTHREAD_COND_INITIALIZER ;
pthread_t req_thread[1000];
int done =1;
int count=0;
int num_threads = 0;

// Kotla : Main routine for worker threads servicing the request
void * start_request (void *t) {
   // Kotla : Signal the main thread to continue
   //printf("Start sleeping \n");
   for (int i=0;i<10;i++) {
	usleep(1000);
   }
   //printf("Done sleeping \n");
   pthread_mutex_lock(&req_queue_mutex);
   count++;
   if (count == num_threads) {
      pthread_cond_signal(&req_ready_cond);
   }
   pthread_mutex_unlock(&req_queue_mutex);
   

}

int main(int argc, char **argv) {

  num_threads = atoi(argv[1]);

  //printf(" Threads = %d \n", num_threads);
  // Initialize mutex
  if (pthread_mutex_init(&req_queue_mutex,NULL)) {
    fprintf(stderr,"Cannot initialize pthread mutex successfully. \n");
    exit(-1);
  }

  // Initialize condition variable
  if (pthread_cond_init(&req_ready_cond,NULL)) {
    fprintf(stderr,"Cannot initialize pthread cond successfully. \n");
    exit(-1);
  }
 
  for (int i=0;i<num_threads;i++) {
    pthread_create(&req_thread[i],NULL,start_request,NULL);
  }

  pthread_mutex_lock(&req_queue_mutex);
  pthread_cond_wait(&req_ready_cond,&req_queue_mutex);
  pthread_mutex_unlock(&req_queue_mutex);
}


