#include<stdio.h>
#include<pthread.h>
pthread_mutex_t req_queue_mutex = PTHREAD_MUTEX_INITIALIZER ;
pthread_cond_t req_ready_cond =  PTHREAD_COND_INITIALIZER ;
pthread_t req_thread;
int done =1;
int count =0;

// Kotla : Main routine for worker threads servicing the request
void * start_request (void *t) {
   // Kotla : Signal the main thread to continue
   pthread_mutex_lock(&req_queue_mutex);
   printf("Inside thread  %d before wait \n", done);
   if (done <= 501 ) { pthread_cond_wait(&req_ready_cond,&req_queue_mutex);}
   printf("Inside thread  %d\n", done);
   done--;
   // Return illegal value so that the calling function proceeds without
   // sending reply (synchronously)
   pthread_cond_signal(&req_ready_cond);
   pthread_mutex_unlock(&req_queue_mutex);
   pthread_detach(pthread_self());
}

int main() {
  // Initialize mutex
  if (pthread_mutex_init(&req_queue_mutex,NULL)) {
    fprintf(stderr,"Cannot initialize pthread mutex successfully. \n");
    exit(-1);
  }

  // Initialize condition variable
  if (pthread_cond_init(&req_ready_cond,NULL)) {
    fprintf(stderr,"Cannot initialize pthread cond successfully. \n");
    exit(-1);
  }

  done = 1;
  while(1) {
    if (pthread_create(&req_thread,NULL,start_request,NULL)) {
        printf(" Could not create a thread succefully \n");
        continue;
    }
    pthread_mutex_lock(&req_queue_mutex);
    printf("Creating thread %d +++++\n",done);
    done++;
    if (done > 500 ) {
        pthread_cond_broadcast(&req_ready_cond);
        pthread_mutex_unlock(&req_queue_mutex);
        break;
    }
    pthread_mutex_unlock(&req_queue_mutex);
  }
  while (done > 10) { pthread_yield();}
}

