#ifndef _SHARED_LIST_h
#define _SHARED_LIST_h 1
#include <list>
#include "Lock.h"

// Monitor wrapper class for list
template <class T> class SharedList {
private :
  std::list<T> li;
  Lock mutex;
  
public :
  SharedList() {}
  ~SharedList() {}

  // number of elements
  int size() {
    mutex.lock();
    int sz = li.size();
    mutex.unlock();
    return sz;
  }

  // Push back new element into the list
  void push_back(T e) {
    mutex.lock();
    li.push_back(e);
    mutex.unlock();
  }

  // Remove element from the list
  void remove(T e) {
    mutex.lock();
    li.remove(e);
    mutex.unlock();
  }

  // Begin
  std::list<T>::iterator begin() {
    return  li.begin();
  }
  
  // End
  std::list<T>::iterator end() {
    return li.end();
  }
};

#endif // SHARED_LIST
