/*
 * Decompiled with CFR 0.152.
 */
package com.quiotix.html.parser;

import com.quiotix.html.parser.HtmlCollector;
import com.quiotix.html.parser.HtmlDocument;
import com.quiotix.html.parser.HtmlParser;
import com.quiotix.html.parser.HtmlScrubber;
import com.quiotix.html.parser.HtmlVisitor;
import com.quiotix.html.parser.MarginWriter;
import com.quiotix.html.parser.TagBlockRenderer;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class HtmlFormatter
extends HtmlVisitor {
    protected MarginWriter out;
    protected int rightMargin = 80;
    protected int indentSize = 2;
    protected static Hashtable tagsIndentBlock = new Hashtable();
    protected static Hashtable tagsNewlineBefore = new Hashtable();
    protected static Hashtable tagsPreformatted = new Hashtable();
    protected static Hashtable tagsTryMatch = new Hashtable();
    protected static final String[] tagsIndentStrings = new String[]{"TABLE", "TR", "TD", "TH", "FORM", "HTML", "HEAD", "BODY", "SELECT"};
    protected static final String[] tagsNewlineBeforeStrings = new String[]{"P", "H1", "H2", "H3", "H4", "H5", "H6", "BR"};
    protected static final String[] tagsPreformattedStrings = new String[]{"PRE", "SCRIPT", "STYLE"};
    protected static final String[] tagsTryMatchStrings = new String[]{"A", "TD", "TH", "TR", "I", "B", "EM", "FONT", "TT", "UL"};
    protected TagBlockRenderer blockRenderer = new TagBlockRenderer();
    protected HtmlDocument.HtmlElement previousElement;
    protected boolean inPreBlock;

    public HtmlFormatter(OutputStream os) throws Exception {
        this.out = new MarginWriter(new PrintWriter(new BufferedOutputStream(os)));
        this.out.setRightMargin(this.rightMargin);
    }

    public void setRightMargin(int margin) {
        this.rightMargin = margin;
        this.out.setRightMargin(this.rightMargin);
    }

    public void setIndent(int indent) {
        this.indentSize = indent;
    }

    public void visit(HtmlDocument.TagBlock block) {
        boolean alreadyDone = false;
        int wasMargin = 0;
        if (tagsTryMatch.containsKey(block.startTag.tagName.toUpperCase())) {
            this.blockRenderer.start();
            this.blockRenderer.setTargetWidth(this.out.getRightMargin() - this.out.getLeftMargin());
            this.blockRenderer.visit(block);
            this.blockRenderer.finish();
            if (!this.blockRenderer.hasBlownTarget()) {
                this.out.printAutoWrap(this.blockRenderer.getString());
                this.previousElement = block.endTag;
                return;
            }
        }
        boolean indent = tagsIndentBlock.containsKey(block.startTag.tagName.toUpperCase());
        boolean preformat = tagsPreformatted.containsKey(block.startTag.tagName.toUpperCase());
        if (preformat) {
            this.inPreBlock = true;
            this.visit(block.startTag);
            wasMargin = this.out.getLeftMargin();
            this.out.setLeftMargin(0);
            this.visit(block.body);
            this.out.setLeftMargin(wasMargin);
            this.visit(block.endTag);
        } else if (indent) {
            this.out.printlnSoft();
            this.visit(block.startTag);
            this.out.printlnSoft();
            this.out.setLeftMargin(this.out.getLeftMargin() + this.indentSize);
            this.visit(block.body);
            this.out.setLeftMargin(this.out.getLeftMargin() - this.indentSize);
            this.out.printlnSoft();
            this.visit(block.endTag);
            this.out.printlnSoft();
            this.inPreBlock = false;
        } else {
            this.visit(block.startTag);
            this.visit(block.body);
            this.visit(block.endTag);
        }
    }

    public void visit(HtmlDocument.Tag t) {
        String s = t.toString();
        if (tagsNewlineBefore.containsKey(t.tagName.toUpperCase()) || this.out.getCurPosition() + s.length() > this.out.getRightMargin()) {
            this.out.printlnSoft();
        }
        this.out.print("<" + t.tagName);
        int hanging = t.tagName.length() + 1;
        Enumeration ae = t.attributeList.attributes.elements();
        while (ae.hasMoreElements()) {
            HtmlDocument.Attribute a = (HtmlDocument.Attribute)ae.nextElement();
            this.out.printAutoWrap(" " + a.toString(), hanging);
        }
        if (t.emptyTag) {
            this.out.print("/");
        }
        this.out.print(">");
        this.previousElement = t;
    }

    public void visit(HtmlDocument.EndTag t) {
        this.out.printAutoWrap(t.toString());
        if (tagsNewlineBefore.containsKey(t.tagName.toUpperCase())) {
            this.out.printlnSoft();
            this.out.println();
        }
        this.previousElement = t;
    }

    public void visit(HtmlDocument.Comment c) {
        this.out.print(c.toString());
        this.previousElement = c;
    }

    public void visit(HtmlDocument.Text t) {
        if (this.inPreBlock) {
            this.out.print(t.text);
        } else {
            int start = 0;
            while (start < t.text.length()) {
                int index = t.text.indexOf(32, start) + 1;
                if (index == 0) {
                    index = t.text.length();
                }
                this.out.printAutoWrap(t.text.substring(start, index));
                start = index;
            }
        }
        this.previousElement = t;
    }

    public void visit(HtmlDocument.Newline n) {
        if (this.inPreBlock) {
            this.out.println();
        } else if (this.previousElement instanceof HtmlDocument.Tag || this.previousElement instanceof HtmlDocument.EndTag || this.previousElement instanceof HtmlDocument.Comment || this.previousElement instanceof HtmlDocument.Newline) {
            this.out.printlnSoft();
        } else if (this.previousElement instanceof HtmlDocument.Text) {
            this.out.print(" ");
        }
        this.previousElement = n;
    }

    public void start() {
        this.previousElement = null;
        this.inPreBlock = false;
    }

    public void finish() {
        this.out.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        FileInputStream r = new FileInputStream(args[0]);
        try {
            try {
                HtmlDocument document = new HtmlParser(r).HtmlDocument();
                document.accept(new HtmlCollector());
                document.accept(new HtmlScrubber(58));
                document.accept(new HtmlFormatter(System.out));
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var5_4 = null;
                ((InputStream)r).close();
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((InputStream)r).close();
            throw throwable;
        }
        ((InputStream)r).close();
    }

    static {
        Integer dummy = new Integer(0);
        int i = 0;
        while (i < tagsIndentStrings.length) {
            tagsIndentBlock.put(tagsIndentStrings[i], dummy);
            ++i;
        }
        int i2 = 0;
        while (i2 < tagsNewlineBeforeStrings.length) {
            tagsNewlineBefore.put(tagsNewlineBeforeStrings[i2], dummy);
            ++i2;
        }
        int i3 = 0;
        while (i3 < tagsPreformattedStrings.length) {
            tagsPreformatted.put(tagsPreformattedStrings[i3], dummy);
            ++i3;
        }
        int i4 = 0;
        while (i4 < tagsTryMatchStrings.length) {
            tagsTryMatch.put(tagsTryMatchStrings[i4], dummy);
            ++i4;
        }
    }
}

