/*
 * Decompiled with CFR 0.152.
 */
package com.quiotix.html.parser;

import com.quiotix.html.parser.HtmlVisitor;
import java.util.Enumeration;
import java.util.Vector;

public class HtmlDocument {
    ElementSequence elements;

    public HtmlDocument(ElementSequence s) {
        this.elements = s;
    }

    public void accept(HtmlVisitor v) {
        v.visit(this);
    }

    public static class AttributeList {
        public Vector attributes = new Vector();

        public void addAttribute(Attribute a) {
            this.attributes.addElement(a);
        }
    }

    public static class Attribute {
        public String name;
        public String value;
        public boolean hasValue;

        public Attribute(String n) {
            this.name = n;
            this.hasValue = false;
        }

        public Attribute(String n, String v) {
            this.name = n;
            this.value = v;
            this.hasValue = true;
        }

        public int getLength() {
            return this.hasValue ? this.name.length() + 1 + this.value.length() : this.name.length();
        }

        public String toString() {
            return this.hasValue ? this.name + "=" + this.value : this.name;
        }
    }

    public static class Annotation
    extends HtmlElement {
        String type;
        String text;

        public Annotation(String type, String text) {
            this.type = type;
            this.text = text;
        }

        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return 14 + this.type.length() + this.text.length();
        }

        public String toString() {
            return "<!--NOTE(" + this.type + ") " + this.text + "-->";
        }
    }

    public static class ElementSequence {
        protected Vector elements;

        public ElementSequence(int n) {
            this.elements = new Vector(n);
        }

        public ElementSequence() {
            this.elements = new Vector();
        }

        public void addElement(HtmlElement o) {
            this.elements.addElement(o);
        }

        public Enumeration elements() {
            return this.elements.elements();
        }
    }

    public static class Newline
    extends HtmlElement {
        public static final String NL = System.getProperty("line.separator");

        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return NL.length();
        }

        public String toString() {
            return NL;
        }
    }

    public static class Text
    extends HtmlElement {
        public String text;

        public Text(String t) {
            this.text = t;
        }

        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return this.text.length();
        }

        public String toString() {
            return this.text;
        }
    }

    public static class Comment
    extends HtmlElement {
        public String comment;

        public Comment(String c) {
            this.comment = c;
        }

        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return 3 + this.comment.length();
        }

        public String toString() {
            return "<!" + this.comment + ">";
        }
    }

    public static class TagBlock
    extends HtmlElement {
        public Tag startTag;
        public EndTag endTag;
        public ElementSequence body;

        public TagBlock(String name, AttributeList aList, ElementSequence b) {
            this.startTag = new Tag(name, aList);
            this.endTag = new EndTag(name);
            this.body = b;
        }

        public void accept(HtmlVisitor v) {
            v.visit(this);
        }
    }

    public static class EndTag
    extends HtmlElement {
        public String tagName;

        public EndTag(String t) {
            this.tagName = t;
        }

        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return 3 + this.tagName.length();
        }

        public String toString() {
            return "</" + this.tagName + ">";
        }
    }

    public static class Tag
    extends HtmlElement {
        public String tagName;
        public AttributeList attributeList;
        public boolean emptyTag = false;

        public Tag(String t, AttributeList a) {
            this.tagName = t;
            this.attributeList = a;
        }

        public void setEmpty(boolean b) {
            this.emptyTag = b;
        }

        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            int length = 0;
            Enumeration ae = this.attributeList.attributes.elements();
            while (ae.hasMoreElements()) {
                length += 1 + ((Attribute)ae.nextElement()).getLength();
            }
            return length + this.tagName.length() + 2 + (this.emptyTag ? 1 : 0);
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("<");
            s.append(this.tagName);
            Enumeration ae = this.attributeList.attributes.elements();
            while (ae.hasMoreElements()) {
                s.append(" ");
                s.append(((Attribute)ae.nextElement()).toString());
            }
            if (this.emptyTag) {
                s.append("/");
            }
            s.append(">");
            return s.toString();
        }
    }

    public static abstract class HtmlElement {
        public abstract void accept(HtmlVisitor var1);
    }
}

