/*
 * Decompiled with CFR 0.152.
 */
package com.quiotix.html.parser;

import java.io.PrintWriter;

class MarginWriter {
    protected int tabStop;
    protected int curPosition;
    protected int leftMargin;
    protected int rightMargin;
    protected PrintWriter out;
    protected char[] spaces = new char[256];

    public MarginWriter(PrintWriter out) {
        int i = 0;
        while (i < this.spaces.length) {
            this.spaces[i] = 32;
            ++i;
        }
        this.out = out;
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }

    public void print(String s) {
        if (this.curPosition == 0 && this.leftMargin > 0) {
            this.out.write(this.spaces, 0, this.leftMargin);
            this.curPosition = this.leftMargin;
        }
        this.out.print(s);
        this.curPosition += s.length();
    }

    public void printAutoWrap(String s) {
        if (this.curPosition > this.leftMargin && this.curPosition + s.length() > this.rightMargin) {
            this.println();
        }
        this.print(s);
    }

    public void printAutoWrap(String s, int hanging) {
        if (this.curPosition > this.leftMargin && this.curPosition + s.length() > this.rightMargin) {
            this.println();
            this.out.write(this.spaces, 0, hanging + this.leftMargin);
            this.curPosition = this.leftMargin + hanging;
        }
        this.print(s);
    }

    public void println() {
        this.curPosition = 0;
        this.out.println();
    }

    public void printlnSoft() {
        if (this.curPosition > 0) {
            this.println();
        }
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getCurPosition() {
        return this.curPosition == 0 ? this.leftMargin : this.curPosition;
    }
}

