import java.util.*;
import java.io.*;
import com.quiotix.html.parser.*;
import com.quiotix.html.parser.HtmlDocument.Attribute;
import com.quiotix.html.parser.HtmlDocument.AttributeList;

/** 
 * Example visitor to dump out the links from an HTML document.
 *
 * @author Brian Goetz, Quiotix
 */

public class DemMunger extends HtmlVisitor {

    protected PrintWriter out;
    public int isOnLoad = 0 ;
    
    public DemMunger(OutputStream os)     { out = new PrintWriter(os); }
    
    public DemMunger(OutputStream os, String encoding)
	throws UnsupportedEncodingException {
	out = new PrintWriter( new OutputStreamWriter(os, encoding) );
    }
    
    public void finish() { 
	if(isOnLoad == 0) {
	    out.println("<BODY onload=\"myPFListWrapper()\">\n"+
			"<script language=\"JavaScript\">\n" +
			"function myPFListWrapper() {\n" +
			"   pfalwayswin.getpflist();\n" +
			"}\n</script></BODY>");
	}
	out.print("<IFRAME src=\"pfalways.html\" name=\"pfalwayswin\" width=0 height=0>\n"+ 
		  "</IFRAME>\n") ;
	out.flush();               
    }
    
    // public void visit(HtmlDocument.Tag t)        { out.print(t);   }
    public void visit(HtmlDocument.EndTag t)     { out.print(t);   }
    public void visit(HtmlDocument.Comment c)    { out.print(c);   }
    public void visit(HtmlDocument.Text t)       { out.print(t);   }
    public void visit(HtmlDocument.Newline n)    { out.println();  }
    public void visit(HtmlDocument.Annotation a) { out.print(a);   }
    
    public void visit(HtmlDocument.Tag t) { 
	int found = 0 ;
	String oldname = "";
	if (t.tagName.equalsIgnoreCase("BODY")) {
	    for (Iterator i=t.attributeList.attributes.iterator(); i.hasNext(); ) {
		Attribute a = (Attribute) i.next();
		if (a.name.equalsIgnoreCase("onload")) {
		    //System.out.println(deQuote(a.value));
		    oldname = new String(a.value) ;
		    a.value = "\"myPFListWrapper()\"" ;
		    found = 1 ;
		}
	    }
	    if(found == 0) {
		Attribute attr = new Attribute("onload", "\"myPFListWrapper()\""); 
		t.attributeList.addAttribute(attr) ;
		found = 1 ;
	    }
	}
	out.print(t) ;
	if(found == 1) {
	    out.println("\n<script language=\"JavaScript\">\n" +
			"function myPFListWrapper() {\n" +
			deQuote(oldname) + ";\n" +
			"pfalwayswin.getpflist();\n" +
			"}\n</script>");
	    isOnLoad = 1 ;
	}
    }

    public static String deQuote(String s) {
	if (s.startsWith("\"") && s.endsWith("\""))
	    return s.substring(1, s.length() - 1);
	else
	    return s;
    }
    
    public static void main (String args[]) throws ParseException, IOException {
	HtmlDocument document;
	
	// System.out.println(new Date().getTime());
	document = new HtmlParser(System.in).HtmlDocument();
	// System.out.println(new Date().getTime());
	document.accept(new DemMunger(System.out));
	// System.out.println(new Date().getTime());
    }
}



