import java.io.BufferedReader;
import java.util.StringTokenizer;
import java.io.IOException;

public class BURawReq extends RawReq{

  // !!! DANGER !!!
private boolean artificialDynamic;
private final static int nFields = 1;
  // !!! DANGER !!!
  // Don't forget to update toString(), equals(), and makeClone()
  // if new fields are added.
  //
public RawReq makeClone()
  {
    BURawReq r = new BURawReq();
    this.makeCloneHelper(r); // Super-class copies fields
    Assert.myAssert(nFields == 1);
    r.artificialDynamic = artificialDynamic;
    return r;
  }

public boolean equals(RawReq r)
  {
    if(!(r instanceof BURawReq)){
      return false;
    }
    Assert.myAssert(nFields == 1);
    if(((BURawReq)r).artificialDynamic != artificialDynamic){
      return false;
    }
    return this.equalsHelper(r); // Check fields in superclass
  }

  //
  // Used only in makeClone(), which will take care of initializing everything.
  //
private BURawReq()
  {
  }

public BURawReq(BufferedReader in, 
		boolean sharedProxy_, 
		boolean artificialDynamic_)
throws EndOfInputException, MalformedRecordException
{
  String line;
  StringTokenizer t = null;
  String clientS, timeS, userS, URLS, sizeS, elapsedS;
  String elapsedSS, elapsedSUS;
  int ii;

  artificialDynamic = artificialDynamic_;
  sharedProxy = sharedProxy_;

  int ndx;
  int count = 0;

  method = "GET";

  try{
    line = "init";
    while(line.equals("") || line.equals("init")){
      line = in.readLine();
      if(line == null){
	throw new EndOfInputException();
      }
      line = removeQuotes(line);
      t = new StringTokenizer(line);
      count = t.countTokens();
      if(count == 0){
	throw new EndOfInputException();
      }
      if(count != 6){
	System.err.println("bad count " + count + " line was: " + line + " IGNORE LINE");
	line = "init";
      }
    }      
    Assert.myAssert(line != null, "Line is NULL");
    Assert.myAssert(count == 6);
    Assert.myAssert(t != null);
    clientS = t.nextToken();
    if(sharedProxy){
      client = "sharedProxy";
    }
    else{
      client = clientS;
    }

    timeS = t.nextToken();
    timeMS = Long.parseLong(timeS) * 1000;

    userS = t.nextToken();


    URLS = t.nextToken();
    server = getServerFromURL(URLS).toLowerCase();
    objId = getObjIdFromURL(URLS);
    if(artificialDynamic && objId.equals("")){
      objId = "x?fakeCgi=true";      
    }
    
    sizeS = t.nextToken();
    try{
      size = (new Integer(sizeS)).intValue();
    }
    catch(NumberFormatException e){
      throw new MalformedRecordException("Bad Size: " + line 
					 + " size was: " + sizeS);
    }

    elapsedS = t.nextToken();


    // 
    // Now the fun part. Determine an appropriate squide "code"
    // (which indicates the results of the request in the original
    // system.
    //
    if(elapsedS.equals("0.0")){
      squidCode = RawReq.SQUID_TCP_MEM_HIT;
    }
    else{
      squidCode = RawReq.SQUID_TCP_MISS;
    }
    return;
  }
  catch(IOException e){
    throw new Error("FatalError: IO Exception " + e);
  }
}

private String removeQuotes(String orig){
  int at = 0, to;
  String ret;
  StringBuffer result = new StringBuffer();

  while(orig.charAt(at) == '\"'){
    at++;
  }
 
  to = orig.indexOf('\"', at);
  while(to != -1){
    Assert.myAssert(to != -1, "Bug 1");
    result.append(orig.substring(at, to));
    at = to + 1;
    to = orig.indexOf('\"', at);
  }
  Assert.myAssert(at != -1, "Bug 2");
  result.append(orig.substring(at));
  ret = result.toString();
  Assert.myAssert(ret.indexOf('\"') == -1);
  return ret;
}
  
}
