import java.util.Vector;

/*
 *------------------------------------------------------------------
 *
 * LESS Group 
 * Computer Sciences Department 
 * University of Texas at Austin
 *
 * ClientContext ---
 *          Per-client history information for prediction by partial
 *          matching.
 *
 * $Date: 2003/01/06 06:16:30 $ $Id: ClientContext.java,v 1.1.1.1 2003/01/06 06:16:30 ypraveen Exp $
 *
 * Copyright (c) 2002 by Mike Dahlin
 * 
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for noncommercial use without fee and
 * without written agreement is hereby granted, provided that 
 * the above copyright notice appear in all copies of this software.
 * 
 *------------------------------------------------------------------
 */
public class ClientContext{
private Vector history;
private boolean culled;

public ClientContext(){
  history = new Vector();  // history[0] is most recently seen html file
  culled = false;
}

/*
 *------------------------------------------------------------------
 *
 * getHistory --
 *
 *          Get the relevent history for predicting "winEntry"
 *          
 *
 * Arguments:
 *      int winEntry -- how long ago is the interesting history
 *                      (i.e., how far into the prediction "window"
 *                      are we now?)
 *      int length -- how many entries of history do you want?
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
public String getHistory(int winEntry, int histLength){
  int ii;

  StringBuffer answer = new StringBuffer();
  if(histLength == 0){
    return ";";
  }

  if(culled){
    Assert.myAssert(history.size() > winEntry + histLength);
  }

  if(winEntry + histLength > history.size()){
    return null; // No history this long yet
  }

  Assert.myAssert(history.size() >= winEntry + histLength);

  for(ii = 0; ii < histLength; ii++){
    answer.append(history.elementAt(winEntry + ii));
    answer.append(";");
  }
  return answer.toString();
  
}



/*
 *------------------------------------------------------------------
 *
 * append --
 *
 *          Add the specified element to the history.
 *          The only files relevant to history are .html and .cgi files
 *
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
public void append(String element, int maxLength){
  if(isNewContext(element)){
    history.add(0, element);
  }
  while(history.size() > maxLength){
    history.removeElementAt(history.size() - 1);
    culled = true;
  }
}
  /*
   *          The only files relevant to history are .html and .cgi files
   */
public static boolean isNewContext(String element){
  if(RawReq.isHTMLOrDynamic(element)){
    return true;
  }
  return false;
}

public String toString(){
  int ii;
  StringBuffer sb = new StringBuffer();

  for(ii = 0; ii < history.size(); ii++){
    sb.append(history.elementAt(ii));
    sb.append(" ");
  }
  return sb.toString();
}
};
