import java.util.Hashtable;
import java.util.Enumeration;
import java.io.*;

public class CountMaxSquid{
 
private static Hashtable h;

public static void main(String argv[])
  {
    h = new Hashtable();
    RawReq r;
    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    try{
      while(true){
	r = new SquidRawReq(in, false);
	updateCount(r.getServer());
      }
    }
    catch(MalformedRecordException e){
      System.out.println("Bad line: " + e.toString());
      System.exit(-1);
    }
    catch(EndOfInputException f){
      // OK.
    }

    getMaxServerInfo();
  }


private static void updateCount(String server)
  {
    Integer count = (Integer)h.get(server);
    if(count == null){
      count = new Integer(1);
    }
    else{
      count = new Integer(count.intValue() + 1);
    }
    h.put(server, count);
  }

private static void getMaxServerInfo()
  {
    String maxKey = null;
    int maxValue = 0;
    String secondKey = null;
    int secondValue = 0;
    int count = 0;

    while(count < 100){
      Enumeration keys = h.keys();
      while(keys.hasMoreElements()){
	String key = (String)keys.nextElement();
	Integer value = (Integer)h.get(key);
	if(value.intValue() > maxValue){
	  secondKey = maxKey;
	  secondValue = maxValue;
	  maxKey = key;
	  maxValue = value.intValue();
	}
	else if(value.intValue() > secondValue){
	  secondKey = key;
	  secondValue = value.intValue();
	}
      }
      String reply = "Max [" + count + "]: " + maxKey + " referenced " + maxValue + " times";
      System.out.println(reply);
      count++;
      h.remove(maxKey);
      maxKey = null;
      maxValue = 0;
      secondKey = null;
      secondValue = 0;
    }
  }



};
