import java.util.LinkedList;
import java.util.ListIterator;
import java.io.FileInputStream;
import java.io.IOException;

/*
 *------------------------------------------------------------------
 *
 * LESS Group 
 * Computer Sciences Department 
 * University of Texas at Austin
 *
 * FetchQ ---
 *          A synchronized producer/consumer queue of RawReq objects.
 *
 * $Date: 2003/01/06 06:16:30 $ $Id: FetchQ.java,v 1.1.1.1 2003/01/06 06:16:30 ypraveen Exp $
 *
 * Copyright (c) 2002 by Mike Dahlin.
 * 
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for noncommercial use without fee and
 * without written agreement is hereby granted, provided that 
 * the above copyright notice appear in all copies of this software.
 * 
 *------------------------------------------------------------------
 */
public class FetchQ{

  LinkedList list = new LinkedList();
  
public FetchQ()
  {
  }
  
public synchronized void put(RawReq r)
  {
    list.addLast(r);
    this.notify();
  }

public synchronized RawReq get()
  {
    while(list.size() == 0){
      try{
	this.wait();
      }
      catch(InterruptedException e){
	// Keep waiting.
      }
    }
    RawReq r = (RawReq)list.removeFirst();
    return r;
  }

public synchronized LinkedList cancelAll()
  {
    LinkedList ret = list;
    list = new LinkedList();
    return ret;
  }



public synchronized boolean checkAlreadyQueued(RawReq r)
  {
    RawReq current;
    ListIterator li = list.listIterator();
    while(li.hasNext()){
      current = (RawReq)li.next();
      if(r.equals(current)){
	return true;
      }
    }
    return false;
  }

public static void main(String argv[])
  {
    FetchQ q = new FetchQ();
    int count;
    FileInputStream s;
    InputTrace t;
    int testNum;
    int ii;

    count = 0;
    testNum = 0;
    try{

      
      s = new FileInputStream("test-bu.dat");
      // NB: Raw trace is 256 seconds long w 100 records
      t = new InputTrace(s, "bu", "ALL", "ALL", (float)1000.0);
      try{
	while(true){
	  RawReq r = t.next();
	  q.put(r);
	  count++;
	}
      }
      catch(EndOfInputException e){
	Assert.myAssert(count == 100, "Read all bu.");
      }
      s = new FileInputStream("test-bu.dat");
      // NB: Raw trace is 256 seconds long w 100 records
      t = new InputTrace(s, "bu", "ALL", "ALL", (float)1000.0);
      count = 0;
      try{
	while(true){
	  RawReq r = t.next();
	  RawReq rr = q.get();
	  count++;
	  Assert.myAssert(r.equals(rr));
	}
      }
      catch(EndOfInputException e){
	Assert.myAssert(count == 100, "Read all bu.");
      }
      System.out.println("FetchQ: Pass test 0.");




      //
      // Test 1
      //
      count = 0;
      testNum = 1;
      s = new FileInputStream("test-bu.dat");
      // NB: Raw trace is 256 seconds long w 100 records
      t = new InputTrace(s, "bu", "ALL", "ALL", (float)1000.0);
      try{
	RawReq z = t.next(); // Insert first record 100x then discard it
	count++;
	for(ii = 0; ii < 100; ii++){
	  q.put(z);
	}
	q.cancelAll();
	while(true){
	  RawReq r = t.next();
	  q.put(r);
	  count++;
	}
      }
      catch(EndOfInputException e){
	Assert.myAssert(count == 100, "Read all bu1. " + count);
      }

      s = new FileInputStream("test-bu.dat");
      // NB: Raw trace is 256 seconds long w 100 records
      t = new InputTrace(s, "bu", "ALL", "ALL", (float)1000.0);
      count = 0;
      try{
	RawReq z = t.next(); // Discard first record
	count++;
	while(true){
	  RawReq r = t.next();
	  RawReq rr = q.get();
	  count++;
	  Assert.myAssert(r.equals(rr));
	}
      }
      catch(EndOfInputException e){
	Assert.myAssert(count == 100, "Read all bu2. " + count);
      }
      System.out.println("FetchQ: Pass test 1.");
    }
    catch(IOException i){
      i.printStackTrace();
      Assert.myAssert(false, "IO Exception test " + testNum);
    }
    catch(MalformedRecordException m){
      m.printStackTrace();
      Assert.myAssert(false, "Malformed Record Exception test " + testNum);
    }
  }

};
