/*
 *------------------------------------------------------------------
 *
 * LESS Group 
 * Computer Sciences Department 
 * University of Texas at Austin
 *
 * Fetcher ---
 *          Issues the async demand fetch requests.
 *
 * $Date: 2003/01/06 06:16:30 $ $Id: Fetcher.java,v 1.1.1.1 2003/01/06 06:16:30 ypraveen Exp $
 *
 * Copyright (c) 2002 by Mike Dahlin.
 * 
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for noncommercial use without fee and
 * without written agreement is hereby granted, provided that 
 * the above copyright notice appear in all copies of this software.
 * 
 *------------------------------------------------------------------
 */
public class Fetcher{
  private Cache cache;
  private Stats stats;
  private Prefetcher prefetcher;
  private PrefetchPredictor prefetchPredictor;
  private PerstConnection demandConnection;

private final static int MAX_PIPELINE = 5;

/*
 *------------------------------------------------------------------
 *
 * Fetcher --
 *
 *          Constructor
 *
 * Arguments:
 *      Cache c
 *      Stats s
 *      Prefetcher p
 *
 *   The rest are parameters to the local prefetch algorithm.
 *   Note that for simplicity, we allow clients to use a
 *   local copy of global state to decide what to prefetch.
 *   In the future, we will change this to have the server
 *   pass the prefetch list to the client in the header
 *   of replies to requests.
 *
 *      String predictorStateFile -- local copy of global prefetch state
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
public Fetcher(Cache c, Stats s, Prefetcher p, 
	       PrefetchPredictor pp)
  {
    int ii;

    cache = c;
    stats = s;
    prefetcher = p;
    prefetchPredictor = pp;

    String server = RawReq.getDemandMangledServer();
    int port = RawReq.getDemandMangledPort();
    demandConnection = new PerstConnection(server, port, MAX_PIPELINE);

    FetcherThread reader = new FetcherThread(cache, stats, prefetcher, demandConnection,
					     prefetchPredictor);
    reader.setPriority(Thread.MAX_PRIORITY);
    reader.start();
  }



/*
 *------------------------------------------------------------------
 *
 * asyncFetch --
 *
 *          Issue a pipelined fetch on the persistent connection.
 *          May block if MAX_PIPELINE pipeline dept is exceeded.
 *
 * Arguments:
 *      RawReq req -- the URL to be fetched.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
public void asyncFetch(RawReq req)
  {
    String mangledObjId = req.getDemandMangledPathOnServer();
    PendingRequest pr = new PendingRequest(mangledObjId, req);
    demandConnection.put(pr);
  }
};
