//import HTTPClient.HttpURLConnection;
//import org.w3c.www.protocol.http.HttpURLConnection;
//import org.w3c.www.protocol.http.HttpException;
import java.io.*;
import java.net.*;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
//import java.net.HttpURLConnection;
//import java.net.URLConnection;
/*
 *------------------------------------------------------------------
 *
 * LESS Group 
 * Computer Sciences Department 
 * University of Texas at Austin
 *
 * FetcherThread ---
 *          Pulls data from server and updates stats as things arrive.
 *
 * $Date: 2003/01/06 06:16:30 $ $Id: FetcherThread.java,v 1.1.1.1 2003/01/06 06:16:30 ypraveen Exp $
 *
 * Copyright (c) 2002 by Mike Dahlin.
 * 
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for noncommercial use without fee and
 * without written agreement is hereby granted, provided that 
 * the above copyright notice appear in all copies of this software.
 * 
 *------------------------------------------------------------------
 */
public class FetcherThread extends Thread{
private  Cache cache;
private  Stats stats;
private  Prefetcher prefetcher;
private  PrefetchPredictor prefetchPredictor;
private PerstConnection perstConnection;

public FetcherThread(Cache c, Stats s, Prefetcher p, 
		     PerstConnection pc,
		     PrefetchPredictor pp)
  {
    cache = c;
    stats = s;
    prefetcher = p;
    perstConnection = pc;
    prefetchPredictor = pp;
  }

public void run()
  {
    RawReq r;
    PredRawReq prefetchList[];

    while(true){
      try{
	PendingRequest rply = perstConnection.get(); // Get the next result
	//	System.out.println("Fetch took " + rply.getTime());
	r = (RawReq)rply.getContext();
	if(!rply.getStatusSuccess()){
	  stats.demandFetchFailed(r, rply.getTime());
	}
	else{
	  stats.demandFetchDone(r, rply.getTime());
	  prefetchList = generatePrefetchList(r, rply);
	  if(prefetchList.length > 0){
	    //	    System.out.println("Adding listof " + prefetchList.length + " to prefetcher");
	    prefetcher.asyncFetch(prefetchList);
	  }
	}
      }
      catch(Exception e){
	System.out.println("Fetcher thread got exception " + e + "\n"
			   + "Should we try to continue? For now I just die.");
	e.printStackTrace();
	System.exit(-1);
      }
    }
  }


/*
 *------------------------------------------------------------------
 *
 * generatePrefetchList --
 *
 *          For the current simulation, we cheat and use
 *          a local copy of the global predictor state
 *          to generate a list of stuff to prefetch.
 *
 *          For the real thing, what will happen is the
 *          server will send a list of stuff to prefetch
 *          in the reply.
 *
 *          Note: the Prefetcher (actually the Delayed queue)
 *          will take care of filtering for cache hits, threshold, and
 *          other pending prefetches.
 *
 * Arguments:
 *      RawReq r the demand request
 *      PendingRequest reply -- the answer that came back
 *
 * Results:
 *      A list of Predictions -- the stuff to prefetch.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */

private PredRawReq[] generatePrefetchList(RawReq r,
					  PendingRequest rply)
  {
    long start, end;
    int ii;

    //    start = System.currentTimeMillis();
    //
    // This would really happen at the server.
    //
    PredRawReq pred[] = prefetchPredictor.getList(r);

    //    end = System.currentTimeMillis();
    //    System.out.println("GeneratePrefetchList(" + r.getServer() 
    //    + r.getObjId() + ")  = " + (end-start) 
    //	       + " n=" + (pred != null ? pred.length : 0));
    return pred;
  }




};




