import java.net.* ;
import java.io.* ;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.util.* ;

/* Hint server main thread :
    
     This spawns of HintServerThreads for each connection to send back
     the hints to the requests.

     This also creates the Monitor thread and the monitor thread data
     is made available to the HintServerThreads  -- OK FOR NOW AS I THINK - PRAVEEN
*/


public class HintServer {

    public boolean monitorOn = false;
    public int fixedpflistsize = 10;
    
    public int port = 9000;
    public ServerSocket serverSocket ;
    public Monitor monitor ;
    public boolean clientid = false ;

    public String prefetchStateFile = null ;
    public PrefetchPredictor pp = null;

    public boolean webServer = false ;
    
    public String docMapFile = null ;
    public Hashtable docMap = null ;

    public void doIt(String[] argv) {
	monitor = new Monitor() ;
	readCmdParams(argv) ;
	
	//monitor = new Monitor(demserver, demport, maxpflistsize, threshold, filename) ;
	//monitor.setScheme(scheme) ;
	//monitor.setSleeptime(sleeptime)  ;

	// start the monitor only if the monitorOn is true
	if(monitorOn) {
	    monitor.start() ;
	}
	else {
	    // set curpflistsize 
	    monitor.setCurpflistsize(fixedpflistsize) ;
	}
	
        try {
            serverSocket = new ServerSocket(port);
        } catch (IOException e) {
            System.err.println("Could not listen on port: " + port);
            System.exit(-1);
        }

	// for just checking
	if(prefetchStateFile != null) {
	    //pp = new MarkovPrefetchPredictor("test-squid-2.pred") ;
	    pp = new MarkovPrefetchPredictor(prefetchStateFile) ;
	}

	if(docMapFile != null) {
	    // Read the doc mapping into the Hashtable DocMap
	    docMap = new Hashtable() ;
	    try{
		BufferedReader br = new BufferedReader(new FileReader(docMapFile)) ;
		String line = null ;
		while((line = br.readLine()) != null) {
		    if(line.length() > 0) {
			int index = line.indexOf(" ") ;
			if(index > 0) {
			    String key = line.substring(0, index) ;
			    String val = line.substring(index+1) ;
			    docMap.put(key, val) ;			    
			}
		    }
		}
	    }catch(Exception e) {
		System.out.println("docMapFile reading:"+e) ;
	    }
	    
	    /*for (Enumeration e = docMap.keys() ; e.hasMoreElements() ;) {
		String key = (String)e.nextElement() ;
		System.out.println(key+" -- "+((String)docMap.get(key)).replaceAll(" ","\",\""));
	    }
	    Assert.myAssert((1>10), "huh") ;
	    */
	}

	boolean listening = true ;
	while(listening) {
	    try{ 
		Socket clientSocket = serverSocket.accept() ;
		// start a new HintServerThread now
		new HintServerThread(clientSocket, monitor, this).start() ;
	    } catch (Exception e) {
	        System.err.println(e) ;
		listening = false ;
		//System.exit(-1) ;
	    }
	}	    
	try {
	    serverSocket.close() ;
	}catch (Exception e) {
	    System.err.println(e) ;
	}
    }

     
    public static void main(String[] argv) throws IOException {
	HintServer hs = new HintServer() ;
	hs.doIt(argv) ;
    }
   
    public void readCmdParams(String[] argv) {
	int c ;

	// get from command args
	LongOpt[] longopts = new LongOpt[19];
	
	longopts[0] = new LongOpt("maxpflistsize", LongOpt.REQUIRED_ARGUMENT,
				  null, 0);
	longopts[1] = new LongOpt("threshold", LongOpt.REQUIRED_ARGUMENT,
				  null, 1);
	longopts[2] = new LongOpt("demserver", LongOpt.REQUIRED_ARGUMENT,
				  null, 2);
	longopts[3] = new LongOpt("demport", LongOpt.REQUIRED_ARGUMENT,
				  null, 3);
	longopts[4] = new LongOpt("filename", LongOpt.REQUIRED_ARGUMENT,
				  null, 4);
	longopts[5] = new LongOpt("monitor", LongOpt.NO_ARGUMENT,
				  null, 5);
	longopts[6] = new LongOpt("fixedpflistsize", LongOpt.REQUIRED_ARGUMENT,
				  null, 6);
	longopts[7] = new LongOpt("port", LongOpt.REQUIRED_ARGUMENT,
				  null, 7);
	longopts[8] = new LongOpt("scheme", LongOpt.REQUIRED_ARGUMENT,
				  null, 8);
	longopts[9] = new LongOpt("sleeptime", LongOpt.REQUIRED_ARGUMENT,
				  null, 9);
	longopts[10] = new LongOpt("numsamples", LongOpt.REQUIRED_ARGUMENT,
				  null, 10);
	longopts[11] = new LongOpt("clientid", LongOpt.NO_ARGUMENT,
				  null, 11);
	longopts[12] = new LongOpt("prefetchStateFile", LongOpt.REQUIRED_ARGUMENT,
				  null, 12);
	longopts[13] = new LongOpt("maxTurnValue", LongOpt.REQUIRED_ARGUMENT,
				  null, 13);
	longopts[14] = new LongOpt("maxFilesPerTurn", LongOpt.REQUIRED_ARGUMENT,
				  null, 14);
	longopts[15] = new LongOpt("prefThreshold", LongOpt.REQUIRED_ARGUMENT,
				  null, 15);
	longopts[16] = new LongOpt("logBudget", LongOpt.NO_ARGUMENT,
				  null, 16);
	longopts[17] = new LongOpt("webServer", LongOpt.NO_ARGUMENT,
				  null, 17);
	longopts[18] = new LongOpt("docMapFile", LongOpt.REQUIRED_ARGUMENT,
				  null, 18);
	Getopt g = new Getopt("HintServer", argv, "", longopts, true);

	while((c = g.getopt()) != -1){
	    switch(c){
	    case 0:
		monitor.setMaxpflistsize((new Integer(g.getOptarg())).intValue());
		break;
	    case 1:
		monitor.setThreshold((new Long(g.getOptarg())).longValue()) ;
		break;
	    case 2:
		monitor.setServer(g.getOptarg()) ;
		break;
	    case 3:
		monitor.setPort((new Integer(g.getOptarg())).intValue()) ;
		break;
	    case 4:
		monitor.setFilename(g.getOptarg()) ;
		break;
	    case 5:
		monitorOn = true ;
		break ;
	    case 6:
		fixedpflistsize = (new Integer(g.getOptarg())).intValue();
		break ;
	    case 7:
		port = (new Integer(g.getOptarg())).intValue();
		break;
	    case 8:
		monitor.setScheme(g.getOptarg()) ;
		break;
	    case 9:
		monitor.setSleeptime((new Integer(g.getOptarg())).intValue()) ;
		break;
	    case 10:
		monitor.setNumsamples((new Integer(g.getOptarg())).intValue()) ;
		break;
	    case 11:
		clientid = true ;
		break;
	    case 12:
		prefetchStateFile = g.getOptarg() ;
		break ;
	    case 13:
		monitor.setMaxTurnValue(new Integer(g.getOptarg()).intValue());
		break ;
	    case 14:
		monitor.maxFilesPerTurn = new Integer(g.getOptarg()).intValue();
		break ;
	    case 15:
		monitor.prefThresh = new Float(g.getOptarg()).floatValue();
		break ;
	    case 16:
		monitor.logBudgetInFile = true ;
		break;
	    case 17:
		webServer = true ;
		break ;
	    case 18:
		docMapFile = g.getOptarg() ;
		break ;
	    case '?':
		System.out.println("The option '" + (char)g.getOptopt()
				   + "' is not valid.");
		System.out.println("Runs with the following options \n" +
				   "--maxpflistsize <int> \n" +
				   "--threshold <long> //threshold time above which server is considered loaded\n" +
				   "--demserver <string>\n" +
				   "--demport <int>\n" +
				   "--filename <string>//Monitor will fetch this file from server\n" +
				   "--monitor\n"+
				   "--fixedpflilstsize <int>\n"+
				   "--port <int>\n"+
				   "--scheme <AIAD | AIMD>\n"+
				   "--sleeptime <int> //in ms \n"+
				   "--numsamples <int> \n" +
				   "--clientid //for exps with trace\n" +
				   "--prefetchStateFile <string> // if specified markov predictor with this file is used\n" +
				   "--maxTurnValue <int> // max Turn Value\n" +
				   "--maxFilesPerTurn <int>\n" +
				   "--prefThresh <float> \n"+
				   "--logBudget // log budget in \"budgetLog\"" +
				   "--webServer // act as proper hint server" +
				   "--docMapFile <string> // doc to embedded files mapping" +
				   "") ;
		System.exit(-1);
		break;
	    default:
		System.out.println("getopt() returned " + c);
		System.exit(-1);
		break;
	    }
	}
    }
}
