import java.net.* ;
import java.io.* ;
import java.util.* ;
import java.text.* ;

public class HintServerThread extends Thread {
    private Socket socket = null;
    
    // for getting current pflist size
    private Monitor monitor = null ;
    private HintServer hs = null;

    public PrintWriter out  = null ;
    public BufferedReader in  = null ;
	
    public LinkedList queue = null;
    public boolean webServer = false ;

    // the previous ref from client
    public String fileName = "" ;
    // the turn value from client 
    public int turn = 0 ;

    // the new turn value to return to the client
    public int nturn = 0 ;

    // client id..
    public String clientName = "" ;
    PredRawReq allPreds[] = null ;

    public HintServerThread(Socket socket, Monitor mon, HintServer hs_t) {
        super("HintServerThread");
        this.socket = socket;
	this.monitor = mon ;

	hs = hs_t ;
	webServer = hs_t.webServer ;

	queue = new LinkedList() ;
	//new HintServerThreadWorker(socket, mon, hs_t, queue, this).start() ;
        try {
	    out = new PrintWriter(socket.getOutputStream(), true);
            in = new BufferedReader(
				    new InputStreamReader(
							  socket.getInputStream()));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    boolean twoConnectionArchitecture = true ;
    public void handleWebRequest(String inputLine)
    {
	StringWriter outString = new StringWriter();
	int index = inputLine.indexOf("pflist.html") ;
	if(index >= 0) {
	    index = inputLine.indexOf("PCOOKIE=") ;
	    if(index >= 0) {
		int end = inputLine.indexOf("+",index) ;
		fileName = inputLine.substring(index+8, end) ;
		index = inputLine.indexOf("TURN=", index)  ;
		if(index >= 0) {
		    end = inputLine.indexOf(" ", index) ;
		    turn = Integer.parseInt(inputLine.substring(index+5,end)) ;
		    System.out.println(fileName+"   "+turn) ;

		    // fill clientName 
		    clientName = socket.getInetAddress().getHostAddress() ;
		    
		    if(hs.pp == null) {
			return ;
		    }
			
		    getAllPreds() ;
		    
		    int pflistsize = getListSize(turn) ;
		    nturn = turn + pflistsize ;
		    
		    if(pflistsize <= 0) {
			nturn = -1 ;
		    }

		    checkNTurn() ;

		    if(nturn >= 0 && nturn > turn) {
			outString.write("<HTML> <HEAD> <SCRIPT LANGUAGE=\"JavaScript\">\n") ;
			if(twoConnectionArchitecture || nturn >= 0) {
			    outString.write("function myOnLoad() {\n") ;
			    if(twoConnectionArchitecture) {
				// preload wrappers for each html document here
				// remember to update the following code so that DEMAND server is accessed
				// FILL FILL FILL
				for(int ii = turn; ii < nturn && ii < allPreds.length; ii++) {
				    outString.write("  preload(\""+monitor.server + ":" + monitor.port + allPreds[ii].getObjId() + "\");\n") ;
				}
			    }
			    if(nturn >= 0) {
				outString.write("  getMore() ;\n" +
					  "}\n"  +
					  "function getMore() { \n" +
					  "  document.location=\"/pflist.html+PCOOKIE="+ fileName+ "+TURN="+nturn+"\"; \n"+ 
					  "  document.close();\n") ;
			    }
			    outString.write("}\n") ;
			}
			outString.write("var myfiles=new Array() ;\n" +
				  "function preload(){\n" +
				  "  for (i=0;i<preload.arguments.length;i++){ \n"+
				  "    myfiles[i]=new Image() ; \n" +
				  "    myfiles[i].src=preload.arguments[i] ; \n" +
				  "  } \n" +
				  "} \n" + 
				  "</SCRIPT> </HEAD> <BODY onload=\"myOnLoad()\"> \n" +
				  "<SCRIPT LANGUAGE=\"JavaScript\">     \n") ;
			for(int ii=0; ii<nturn && ii < allPreds.length; ii++) {
				// for each document, extract the pages that needs to be included
			    
				// files[] = getFiles(allPreds[ii].getObjId()) ;
				// for(int jj = 0; jj<files.length; jj++) {
				//        outString.write("preload(\"files[jj]\");\n") ;
				// }
			    if(hs.docMap != null) {
				String val = (String)hs.docMap.get((String)allPreds[ii].getObjId()) ;
				if(val != null) {
				    outString.write("preload(\""+val.replaceAll(" ","\",\"")+"\");\n") ;
				}
			    }
			    outString.write("  preload(\""+allPreds[ii].getObjId()+"\");\n") ;
			}
			outString.write("</SCRIPT> </BODY> </HTML>\n");
		    }
		    
		    // First output the HTML headers and then send this string
		    // FILL FILL headers
		    /*
		      HTTP/1.1 200 OK
		      Content-Length: 2788
		      Server: GWS/2.0
		      Date: Tue, 11 Feb 2003 00:09:13 GMT
		      Content-Type: text/html
		      
		     */
		    SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss z"); 
		    formatter.setTimeZone(TimeZone.getTimeZone("GMT")) ;
		    
		    outString = new StringWriter() ;
		    outString.write("<HTML> hahahahah </HTML>\n");

		    out.print("HTTP/1.1 200 OK\n"+
			      "Content-Length: "+outString.toString().length()+"\n" +
			      "Date: "+formatter.format(new Date())+"\n" +
			      "Content-Type: text/html\n\n") ;


		    System.out.println("locally\n"+outString.toString()) ;
		    out.print(outString.toString()) ;
		    out.flush() ;
		    outString.flush() ;
		    /*
		      <HTML> <HEAD> <SCRIPT LANGUAGE="JavaScript"> 
		      function myOnLoad() { 
		         //exeutes after body loads 
			 preload("DEMAND-SERVER/c.html"); //For two-conn only 
			 getMore() ; 
		      } 
		      function getMore() { 
		         document.location="HINT-SERVER/pflist.html + PCOOKIE=" + 
			                   document.referrer + "+" + prevref + "+" + "TURN=2"; 
			 document.close(); 
		      } 
		      var myfiles=new Array() 
		      function preload(){ 
		         for (i=0;i<preload.arguments.length;i++){ 
			    myfiles[i]=new Image() ; 
			    myfiles[i].src=preload.arguments[i] ; 
			 } 
		      } 
		      </SCRIPT> </HEAD> <BODY onload="myOnLoad()"> 
		      <SCRIPT LANGUAGE="JavaScript"> 
		          preload("PREFETCH-SERVER/a.jpg", 
			          "PREFETCH-SERVER/b.jpg", 
				  "PREFETCH-SERVER/c.html"); 
		      </SCRIPT> </BODY> </HTML> 
		    */
		    // get the list of things to send -- by getting budget from monitor and then getting list from the pred file
		    // send them to the client on the out stream
		    // return
		    // Future: Check if it is from a Mozilla browser(or netscape 7?), then
		    // use mozilla prefetching mechanism.. much cleaner!
		}
	    }
	}
	return ;
    }

    public void run() {
	String inputLine ;
	setPriority(Thread.MIN_PRIORITY);

	try {
	    // for supporting tests
	    if(!webServer) {
		while ((inputLine = in.readLine()) != null) {
		    sendResponse(inputLine) ;
		}
	    }
	    else {
		while ((inputLine = in.readLine()) != null) {
		    //parseInputLine(inputLine) ; // testing purpose only
		    //System.out.println(fileName+";"+turn+";"+clientName) ;
		    System.out.println(inputLine) ;
		    if(inputLine.indexOf("GET") == 0) {
			handleWebRequest(inputLine) ;
		    }
		}
	    }
	} catch (Exception e) {
            e.printStackTrace();
        }
  	try{
            out.close();
            in.close();
            socket.close();
	    
	}catch (Exception e) {
	}
    }
    
    public int currReturnCount = 0 ;
    public int maxReturnCount = 3 ;
    public Date d = null ;

    public boolean shdThisRequestReturn() {
	if(d == null) {
	    d = new Date() ;
	    currReturnCount = 0 ;
	}
	else {
	    Date dt = new Date() ;
	    if(dt.getTime() - d.getTime() > monitor.sleeptime) {
		d = dt ;
		currReturnCount = 0 ;
	    }
	}
	
	if(currReturnCount < maxReturnCount) {
	    currReturnCount ++ ;
	    return true ;
	}
	return false ;
    }

    public int getListSize(int turn) {
	int pflistsize = 0 ;
	if(hs.monitorOn) {
	    pflistsize = monitor.getListSize(turn) ;
	}
	else{
	    pflistsize = monitor.getCurpflistsize() ;
	    if(pflistsize > 70) {
		pflistsize = 70 ; // Hack so that no more than 70 goes!!		
	    }
	    
	    if(hs.pp == null & turn != 0) { // K times prefetching. only first time // && turn < monitor.getMaxTurnValue()) {
		pflistsize = 0 ;
	    }
	}
	return pflistsize ;
    }


    public void parseInputLine(String inputLine) {
	int index, end ;
	if(hs.clientid) {
	    //read the client id from input line ;
	    end = inputLine.indexOf(" ") ;
	    Assert.myAssert((end > 0), "did not get the client id") ;
	    
	    clientName = inputLine.substring(0, end) ;
	    
	    // get turn value now
	    index = end+1 ;
	    end = inputLine.indexOf(" ", index) ;
	    turn = Integer.parseInt(inputLine.substring(index, end)) - 1 ;
	    //turn = new Integer(inputLine.substring(place+1, place+1+place2)).intValue() - 1; // -1 because koku does not want to give 0
	    Assert.myAssert((turn >= 0), "received turn less than 0") ;
	    fileName = inputLine.substring(end+1) ;
	}
	else {
	    fileName = inputLine ;
	}
    }

    boolean isOlympicsPresent = false ;
    // following function fills the allPreds[] array
    // note that this requires that clientName was filled!!
    public void getAllPreds() {
	Assert.myAssert((hs.pp != null), "Specify Pred File") ;
	// Do we need this check?????
	if(fileName.indexOf("Olympics",1) == 1) {
	    fileName = fileName.substring(9) ;
	    isOlympicsPresent = true ;
	}
	PredRawReq rr = new PredRawReq(new Prediction("http://www.pfnice.edu"+fileName, (float)1.0));
	if(hs.clientid && !clientName.equals("")){
	    rr.client = clientName ;
	}
	allPreds = hs.pp.getList(rr);	
    }

    public void checkNTurn() {
	if(allPreds != null) {
	    if(allPreds.length < nturn) {
		if(allPreds.length > turn) {
		    nturn = allPreds.length ;	
		}
		else {
		    nturn = -1 ;
		}
	    }
	    if(nturn > 0 && !hs.monitorOn && monitor.prefThresh >= 0.0) {
		int ii ;
		for(ii = turn; ii < allPreds.length && ii <  nturn; ii++) {
		    if(allPreds[ii].getProb() < monitor.prefThresh) break ;
		}
		nturn = ii ;
		if(ii == turn) {
		    nturn = -1 ;
		}
	    }
	}
	else {
	    nturn = -1 ;
	}
    }
    

    public synchronized void sendResponse(String inputLine) {
	String outputLine;
	
	try {
	    //System.out.println("Read from a client:" + inputLine) ;
	    
	    parseInputLine(inputLine) ;
	    int pflistsize = getListSize(turn) ;
	    nturn = turn + pflistsize ;

	    if(pflistsize <= 0) {
		nturn = -1 ;
	    }
	    if(hs.monitorOn) {
		if(pflistsize > 0 || (turn < monitor.getMaxTurnValue())) {
		    monitor.incCount() ; // for this time period increment the estimate
		}
		
		if(pflistsize == 0 && 
		   turn < monitor.getMaxTurnValue()) {
		    
		    // currently not in use --- YP
		    // instead sending -2 back for first n clients // This one ditched too :)))
		    // add the request to the queue
		    if(false) {
			synchronized(queue) {
			    if(queue.size() < 10) {
				queue.add(new Date()) ;
				queue.add(inputLine) ;
				//System.out.println("Queuelength from HST: "+queue.size()) ;
				queue.notify() ;
			    }
			}
			// ----- NEW HACK here
			if(shdThisRequestReturn()) {
			    nturn = turn ;
			}
		    }
		}
	    }

	    if(hs.pp != null) {
		
		getAllPreds() ;

		checkNTurn() ;

		if(hs.clientid) {
		    out.print(clientName+" ") ;
		}		    
		out.print(nturn+" "+fileName+" ") ;
		for(int ii = turn; ii < allPreds.length && ii <  nturn; ii++) {
		    if(ii > turn) {
			out.print(" ") ;
		    }
		    if(isOlympicsPresent) {
			out.print("/Olympics") ;
		    }
		    out.print(allPreds[ii].getObjId());
		}
		out.print(";") ;	
		out.flush() ;
	    }
	    else {
		
		// System.out.println("For client... pflistsize:"+pflistsize+" nturn:"+nturn) ;
		
		if(hs.clientid) {
		    out.print(clientName+" ") ;
		    out.print(nturn+" "+fileName+" ") ;
		}
		for(int ii = 0; ii < pflistsize; ii++) {
		    if(ii==0) {
			out.print(fileName);
		    }
		    else {
			out.print(" "+fileName);
		    }
		}
		out.print(";") ;	
		out.flush() ;
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
}




