import java.net.* ;
import java.io.* ;
import java.util.* ;

public class HintServerThreadWorker extends Thread {
    private Socket socket = null;
    
    // for getting current pflist size
    private Monitor monitor = null ;
    private HintServer hs = null;
    private LinkedList queue = null ;
    private HintServerThread hst = null ;

    public HintServerThreadWorker(Socket socket, 
				  Monitor mon, 
				  HintServer hs_t, 
				  LinkedList q_t, 
				  HintServerThread hst_t) {
        super("HintServerThreadWorker");
        this.socket = socket;
	this.monitor = mon ;
	this.hs = hs_t ;
	this.hst = hst_t ;
	this.queue = q_t ;
    }

    public void run() {
	String inputLine;
	
	try {
	    while(true) {
		Date d = null ;
		synchronized(queue) {
		    if(queue.isEmpty()) {
			queue.wait() ;
		    }
		}
		if(queue.isEmpty()) {
		    // time to die 
		    System.out.println("HUIHUHUHUH\n") ;
		    return ;
		}
		
		synchronized(queue) {
		    d = (Date)queue.removeFirst() ;
		    inputLine = (String)queue.removeFirst() ;
		}
		long diff = monitor.sleeptime -(new Date().getTime()-d.getTime()) ;
		
		if(diff > 0) {
		    synchronized(this) {
			wait(diff) ;
		    }
		}
		hst.sendResponse(inputLine) ;
	    }
	    
	} catch (Exception e) {
	    e.printStackTrace();
	}
	
    }
}

