import java.io.*;
import java.util.*;
import java.util.LinkedList;

/*
 *------------------------------------------------------------------
 *
 * LESS Group 
 * Computer Sciences Department 
 * University of Texas at Austin
 *
 * MarkovPredictionList ---
 *          
 *
 * $Date: 2003/01/06 06:16:30 $ $Id: MarkovPredictionList.java,v 1.1.1.1 2003/01/06 06:16:30 ypraveen Exp $
 *
 * Copyright (c) 2002 by Mike Dahlin
 * 
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for noncommercial use without fee and
 * without written agreement is hereby granted, provided that 
 * the above copyright notice appear in all copies of this software.
 * 
 *------------------------------------------------------------------
 */
public class MarkovPredictionList implements Serializable{
  // A MPL can either be in adding mode -- in which case
  // the state is in a hashtable {key} --> {count}
  // Or it can be in reading mode -- in which case the 
  // state is on a list of Predictions sorted by Prediction.probability
  //
private Hashtable accumulationList;

public MarkovPredictionList(){
  accumulationList = new Hashtable();
}

/*
 *------------------------------------------------------------------
 *
 * add --
 *
 *       We just saw <result> in the context with which this
 *       prediction list is associated.
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
public void add(String result){

  Integer count = (Integer)accumulationList.get(result);
  if(count == null){
    count = new Integer(1);
  }
  else{
    count = new Integer(count.intValue() + 1);
  }
  accumulationList.put(result, count);
  return;
}


/*
 *------------------------------------------------------------------
 *
 * normalizeCullAndSort --
 *
 *      Normalize the counts into a probability
 *      Cull predictions whose probability is less than threshold
 *      Create a sorted list of predictions
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      Return true if the resulting list is non-empty
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */

public Prediction[] normalizeCullAndSort(int totCount, float threshold){

  int ii;
  LinkedList tmpList = new LinkedList();
  Enumeration keys = accumulationList.keys();
  while(keys.hasMoreElements()){
    String key = (String)keys.nextElement();
    int count = ((Integer)accumulationList.get(key)).intValue();
    // Normalize
    float frac = ((float)count)/(float)totCount;
    // Cull
    if(frac >= threshold){
      String URL = "http://" + key;
      // Sort
      insertSorted(tmpList, new Prediction(URL, frac));
    }
  }

  Prediction predictionList[] = new Prediction[tmpList.size()];
  for(ii = 0; ii < predictionList.length; ii++){
    predictionList[ii] = (Prediction)tmpList.remove(0);
  }
  Assert.myAssert(tmpList.size() == 0);
  return predictionList;
}

/*
 *------------------------------------------------------------------
 *
 * insertSorted --
 *
 *          List is sorted in descending order.
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */

private void insertSorted(LinkedList list, Prediction p)
  {
    Prediction prev = null;
    ListIterator li = list.listIterator(0);
    while(li.hasNext()){
      //
      // Once we do "next()", ListIterator's "cursor"
      // is *after* the item returned and *before*
      // the next item we would get if we call "next"
      //
      Prediction current = (Prediction)li.next();
      if(prev != null){
	Assert.myAssert(prev.getProb() >= current.getProb());
      }
      if(current.getProb() < p.getProb()){
	li.previous();
	// Put curser before the item we looked at
	li.add(p);
	return;
      }
    }
    li.add(p);
  }




public String toString(){
  StringBuffer sb = new StringBuffer();
  Enumeration keys = accumulationList.keys();
  while(keys.hasMoreElements()){
    String key = (String)keys.nextElement();
    int count = ((Integer)accumulationList.get(key)).intValue();
    sb.append("{");
    sb.append(key + " " + count);
    sb.append("}");
  }
  return sb.toString();
}
};
