import java.io.*;
import java.util.*;

//
// Given N gzipped files, each containing
// squid trace records, produce as output 
// a sorted file (not gzipped; pipe to 
// gzip if that is what you want) 
// that is the merge of all of them.
//
// usage
// java MergeSortedGzipped fieldIndex file1.gz file2.gz...
//
// Where fieldIndex is the index (starting from 0) of
// the field to sort on.
//


public class MergeSortedGzipped{
  static int field;
  static int nfiles;
  static String fileNames[];
  static Process processes[];
  static BufferedReader inputs[];
  static String topLines[];
  static int topValues[];
  static int topValuesSoFar[];
  static int malformedCount[];
  static int goodCount[];

public static void main(String argv[]){
  int ii;
  Assert.myAssert(argv.length > 2, 
		"usage: java MergeSortedGzipped fieldIndex file1.gz file2.gz...");
  
  field = Integer.parseInt(argv[0]);
  nfiles = argv.length - 1;
  fileNames = new String[nfiles];
  processes = new Process[nfiles];
  inputs = new BufferedReader[nfiles];
  topLines = new String[nfiles];
  topValues = new int[nfiles];
  topValuesSoFar = new int[nfiles];
  malformedCount = new int[nfiles];
  goodCount = new int[nfiles];
  Runtime runtime = Runtime.getRuntime();
  for(ii = 0; ii < nfiles; ii++){
    String command = "gunzip -c " + argv[ii+1];
    System.err.println(command);
    try{
      processes[ii] = runtime.exec(command);
      inputs[ii] = new BufferedReader(new InputStreamReader(processes[ii].getInputStream()), 8192);
    }
    catch(Exception e){
      System.err.println("Cannot start process " + ii + " " + command);
      System.exit(-1);
    }
    malformedCount[ii] = 0;
    goodCount[ii] = 0;
    topValuesSoFar[ii] = Integer.MIN_VALUE;
  }
  suckFirst();
  suckAndBlow();
}

public static void suckFirst(){
  int ii;
  for(ii = 0; ii < nfiles; ii++){
    try{
      suck(ii);
    }
    catch(IOException e){
      System.err.println("Cannot start reading stream " + ii + " " + e);
      System.exit(-1);
    }
  }
}


private static void suckAndBlow(){
  int ndx = findMin();
  while(ndx != -1){  
    blow(ndx);
    try{
      suck(ndx);
    }
    catch(IOException e){
      System.err.println("Error reading input " + ndx + " " + e);
      System.exit(-1);
    }
    ndx = findMin();
    System.gc();
  }
}

private static int getKeyValue(String line)
  throws MalformedRecordException{

  StringTokenizer t = new StringTokenizer(line);
  int ii;
  int count;
  count = t.countTokens();
  if(count < field){
    throw new MalformedRecordException("Too few fields in record");
  }
  for(ii = 0; ii < field; ii++){
    try{
      t.nextToken();
    }
    catch(NoSuchElementException e){
      System.err.println(e.toString());
      System.exit(-1);
    }
  }
  return Integer.parseInt(t.nextToken());
}

private static int findMin(){
  int ii;
  int min = Integer.MAX_VALUE;
  int ndx = -1;

  for(ii = 0; ii < nfiles; ii++){
    if(topLines[ii] != null){
      if(topValues[ii] <= min){
	ndx = ii;
	min = topValues[ii];
      }
    }
  }
  return ndx;
}

private static void blow(int ii){
  System.out.println(topLines[ii]);
}

private static void suck(int ii)
    throws IOException{
  topLines[ii] = null;
  while(topLines[ii] == null){
    try{
      topLines[ii] = inputs[ii].readLine();
      if(topLines[ii] == null){
	topValues[ii] = -9999;
	return; // Null topLines[ii] means eof[ii]
      }
      topValues[ii] = getKeyValue(topLines[ii]);
      Assert.myAssert(topValues[ii] >= topValuesSoFar[ii],
		    "Input " + ii + " not in sorted order: " 
		    + topLines[ii] + " " + topValues[ii] + " v " 
		    + topValuesSoFar[ii]);
      topValuesSoFar[ii] = topValues[ii];
    }
    catch(MalformedRecordException mre){
      topLines[ii] = null; // keep trying
      malformedCount[ii] ++;
      Assert.myAssert(malformedCount[ii] < 10 
		    || malformedCount[ii] < 0.001 * goodCount[ii],
		    "Something is wrong -- many mal-formed records in trace " + ii + 
		    " " + malformedCount[ii] + " of " + goodCount[ii]);
    }
  }
}


};
