import java.net.* ;
import java.io.* ;
import java.util.* ;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;


public class Monitor extends Thread{

    public int curpflistsize = Integer.MAX_VALUE;

    // globals set by arguements
    public String server = "balsam.cs.utexas.edu" ;
    public int port = 8083;    
    public int maxpflistsize = 100;
    public long threshold = 50;
    public String filename = "preload-check/imagecheck.html";
    public String scheme = "AIMD";
    public int sleeptime = 200;
    
    public long[] samples ;
    public int curindex  = 0;
    public int numsamples = 5;

    public long time = 0;

    // for printing purposes
    public long lasttime = 0;

    public int maxTurnValue = 10 ;
    public Random randomGen = new Random(1);

    // For fixed threshold values
    public float prefThresh = (float)-1.0;

    public void initSamples() {
	samples = new long[numsamples] ;
	for(int ii=0; ii <numsamples; ii++) {
	    samples[ii] = 0 ;
	}
    }

    public FileWriter budgetLog = null ;
    public boolean logBudgetInFile = false ;
    public Monitor() {
	initSamples() ;
	try{
	    if(logBudgetInFile) {
		budgetLog = new FileWriter(new File("budgetLog")) ;
	    }	    
	}catch(Exception e) {
	    System.out.println(e) ;
	    System.exit(1) ;
	}
    }

    public void setServer(String ser_t) {
	server = ser_t ;
    }

    public void setPort(int port_t) {
	port = port_t;
    }

    public void setMaxpflistsize(int sz) {
	maxpflistsize = sz ;
    }
    
    public void setThreshold(long threshold_t) {
	threshold = threshold_t ;
    }
    
    public void setFilename(String filename_t) {
	filename = filename_t ;
    }

    public int getCurpflistsize() {
	return curpflistsize ;
    }

    public void setCurpflistsize(int sz) {
	curpflistsize = sz;
    }

    public void setMaxTurnValue(int val) {
	maxTurnValue = val ;
    }

    public int getMaxTurnValue() {
	return maxTurnValue ;
    }

    public void setScheme(String scheme_t) {
	scheme = scheme_t ;
	if(scheme.indexOf("AIMD") < 0 &&
	   scheme.indexOf("AIAD") < 0) {
	    System.err.println("Unknown scheme: "+scheme) ;
	    System.err.println("Valid set = {AIMD, AIAD}");
	    System.exit(-1) ;
	}
    }

    public void setSleeptime(int time) {
	sleeptime = time ;
    }

    public void setNumsamples(int numsam) {
	if(numsamples != numsam) {
	    numsamples = numsam ;
	    initSamples() ;
	}
    }

    public long getRunningAverage() {
	long sum = 0 ;
	for(int ii = 0; ii < numsamples; ii++) {
	    sum += samples[ii] ;
	}
	return sum/numsamples ;
    }

    public void decreaseSize() {
	if(scheme.indexOf("AIMD") >=0) {
	    curpflistsize *= 0.5 ;
	}
	else if(scheme.indexOf("AIAD") >=0) {
	    if(curpflistsize > 0) {
		curpflistsize-- ;
	    }
	}
	else {
	    System.err.println("Vague scheme "+scheme) ;
	    System.exit(-1) ;
	}			
    }


    public void incCount() {
	synchronized(countEstimates) {
	    currCount ++ ;
	}
    }

    public LinkedList countEstimates = new LinkedList() ;
    public int totalEstimate = 0 ;
    public int currentEstimate = 0 ;
    public int budgetLeft = 0 ;
    public int budget = 0 ;

    public int maxFilesPerTurn = 2 ;
    public int currCount = 0 ;

    public void updateCurrentEstimate() {
	int count = 0 ;
	synchronized(countEstimates) {
	    count = currCount ;
	    currCount = 0 ;
	}
	// calculate the current estimate
	if(countEstimates.size() >= 1) {
	    totalEstimate -= ((Integer)countEstimates.removeFirst()).intValue() ;
	}
	totalEstimate += count ;
	countEstimates.add(new Integer(count)) ;
	
	currentEstimate = totalEstimate/countEstimates.size() ;
    }

    public long totBudLeft = 0 ;
    public long totBud = 0 ;
    public void updateBudget() {
	synchronized(countEstimates) {
		totBudLeft += budgetLeft ;
		totBud += budget ;
	    // if(budgetLeft > 0) {
	    // System.out.println("Budget Left: "+budgetLeft+ " current Est:"+currentEstimate+" currCount"+currCount) ;
	    // }
	    budget = curpflistsize;
	    budgetLeft = budget ;
	}
    }

    public int getListSize(int turnVal) {
	// do we need "TURN" value as input here?
	int size = 0 ;
	int granularity = 1  ;

	// NOTE: Make sure that maxturnvalue is greater than granularity and possibly a multiple

	if(turnVal >= getMaxTurnValue()) {
	    return 0 ;
	}
	
	float randval = randomGen.nextFloat() ;
	
	if(currentEstimate > 0) {
	    float tsize = (float)budget/(float)(currentEstimate *granularity);

	    float fractionListSize = tsize - (int)tsize ;
	    size = (int)tsize  ;
	    
	    if(randval < fractionListSize) {
		size ++ ;
	    }
	    size *= granularity ;
	}
	else {
	    size = 99999 ;
	}

	// Give out stuff as if its not yours...
	size+=granularity;


	if(size > maxFilesPerTurn) {
	    size = maxFilesPerTurn ;
	}

	// HACK.. for testing koku's hypothesis!!!
	// REMOVE me soon
	if(size < maxFilesPerTurn) {
	    size = maxFilesPerTurn ;
	}

	if(size > getMaxTurnValue()-turnVal){
	    size = getMaxTurnValue()-turnVal ;
	}

	synchronized(countEstimates){
	    if(size > budgetLeft) {
		size = budgetLeft ;
	    }
	    
	    budgetLeft -= size ;
	}

	return size ;	
    }

    public void log() {
	long now = System.currentTimeMillis() ;
	if(now - lasttime > 10000) { // true once in 10 secs
	    System.out.println("Current budget is "+ curpflistsize + " currentEstimate: "+ currentEstimate + " totbudleft: "+totBudLeft+" totBud: "+totBud) ;
	    //totBudLeft = 0 ;
	    //totBud = 0 ;
	    lasttime = now ;
	}
	if(logBudgetInFile) {
	    try{
		budgetLog.write(" "+new Date().getTime()) ;
		budgetLog.write("  "+curpflistsize+"\n") ;
		//budgetLog.flush() ;
	    }catch(Exception e) {
		System.out.println(e) ;
		System.exit(1) ;
	    }
	}
    }

    public void updatePflistsize(long time) {
	if(time > threshold) {
	    decreaseSize() ;
	    curindex = 0 ; // reset the samples
	    return ;
	}

	samples[curindex] = time ;
	curindex ++ ;
	curindex %= numsamples ;

	if(curindex == 0) {
	    long ravg = getRunningAverage() ;
	    if(ravg > threshold) {
		decreaseSize() ;
	    }
	    else {
		if(curpflistsize < maxpflistsize){
		curpflistsize++ ;
		}
	    }
	}

	log();
    }
    
    public void run() {
	PerstConnection myconn = null ;
	long start, stop ;

	MeasuringThread worker ;


	// initialize curpflistsize
	curpflistsize = 0 ;
	
	setPriority(Thread.MAX_PRIORITY);

	while(true) {
	    start = System.currentTimeMillis() ;
	    try {
		worker = new MeasuringThread(this) ;
		worker.start() ;
		worker.setPriority(Thread.MAX_PRIORITY);
		Thread.sleep(sleeptime) ;
		if(!worker.done) {
		    worker.interrupt() ;
		    time = 10000 ; //big value of 10 seconds.. uff
		}
		//System.out.println("time is "+ time) ;
		//New funda -- 
		// if time returned is bad, then make sure it is bad
		//     by sending another probe and waiting for only 2*thresh
		
		if(time > threshold) {
		    worker = new MeasuringThread(this) ;
		    worker.start() ;
		    Thread.sleep(2*threshold) ;
		    if(!worker.done) {
			worker.interrupt() ;
			time = 10000 ; //big value of 10 seconds.. uff
		    }
		}
		
		updatePflistsize(time) ;
		
		updateBudget() ;
		updateCurrentEstimate() ;
		//System.out.println("Current pflist size is "+ curpflistsize) ;
	    }catch(Exception e) {
		System.out.println(e) ;
	    }
	}
    }

    protected class MeasuringThread extends Thread {
	public Monitor mon ;
	public boolean done  ;
	
	public MeasuringThread(Monitor mon_t) {
	    mon = mon_t ;
	    done = false ;
	}
	
	public void run() {
	    PerstConnection myconn = null ;
	    long start, stop ;
	    
	    start = System.currentTimeMillis() ;
	    try {
		myconn = new PerstConnection(mon.server, mon.port, 1) ;
		if(myconn != null) {
		    myconn.put(new PendingRequest(mon.filename , null)) ;
		    
		    PendingRequest pr = myconn.get() ;
		    if(pr.getStatusSuccess()) {
			stop = System.currentTimeMillis() ;
			mon.time = stop - start ;
			done = true ;
		    }
		    myconn.disconnect() ;
		}
	    }catch(Exception e) {
		System.out.println(e) ;
	    }
	}
    }

    public Monitor(String server_t, 
			int port_t, 
			int maxpflistsize_t,
			long threshold_t,
			String filename_t) {
	server = server_t ;
	port = port_t ;
	maxpflistsize = maxpflistsize_t ;
	threshold = threshold_t ;
	filename = filename_t ;
	initSamples() ;
    }


    public static void main(String[] argv)
    {
	int c ;

	// default global values
	int maxpflistsize = 100 ;
	long threshold = 50 ;
	String server = "balsam.cs.utexas.edu" ;
	int port = 8083 ;
	String filename = "preload-check/imagecheck.html" ;
	
	// get from command args
	LongOpt[] longopts = new LongOpt[5];
	
	longopts[0] = new LongOpt("maxpflistsize", LongOpt.REQUIRED_ARGUMENT,
				  null, 0);
	longopts[1] = new LongOpt("threshold", LongOpt.REQUIRED_ARGUMENT,
				  null, 1);
	longopts[2] = new LongOpt("server", LongOpt.REQUIRED_ARGUMENT,
				  null, 2);
	longopts[3] = new LongOpt("port", LongOpt.REQUIRED_ARGUMENT,
				  null, 3);
	longopts[4] = new LongOpt("filename", LongOpt.REQUIRED_ARGUMENT,
				  null, 4);
	Getopt g = new Getopt("Monitor", argv, "", longopts, true);
	while((c = g.getopt()) != -1){
	    switch(c){
	    case 0:
		maxpflistsize = (new Integer(g.getOptarg())).intValue();
		break;
	    case 1:
		threshold = (new Long(g.getOptarg())).longValue();
		break;
	    case 2:
		server = g.getOptarg();
		break;
	    case 3:
		port = (new Integer(g.getOptarg())).intValue();
		break;
	    case 4:
		filename = g.getOptarg();
		break;
	    case '?':
		System.out.println("The option '" + (char)g.getOptopt()
				   + "' is not valid.");
		System.exit(-1);
		break;
	    default:
		System.out.println("getopt() returned " + c);
		System.exit(-1);
		break;
	    }
	}
	
	Monitor mon = new Monitor(server, port, maxpflistsize, threshold, filename) ;
	mon.run() ; // not running the thread!!!
    }
}
		
		
