import java.io.BufferedReader;
import java.util.StringTokenizer;
import java.io.IOException;

public class OlympicRawReq extends RawReq{

  // !!! DANGER !!!
    //??private boolean artificialDynamic;
    private final static int nFields = 0;

  // !!! DANGER !!!
  // Don't forget to update toString(), equals(), and makeClone()
  // if new fields are added.
  //
public RawReq makeClone()
  {
    OlympicRawReq r = new OlympicRawReq();
    this.makeCloneHelper(r); // Super-class copies fields
    Assert.myAssert(nFields == 0);
    //r.artificialDynamic = artificialDynamic;
    return r;
  }

public boolean equals(RawReq r)
  {
    if(!(r instanceof OlympicRawReq)){
      return false;
    }
    Assert.myAssert(nFields == 0);
    //    if(((BURawReq)r).artificialDynamic != artificialDynamic){
    // return false;
    //}
    return this.equalsHelper(r); // Check fields in superclass
  }

  //
  // Used only in makeClone(), which will take care of initializing everything.
  //
private OlympicRawReq()
  {
  }

public OlympicRawReq(BufferedReader in, 
		     boolean sharedProxy_)
		     //,		     boolean artificialDynamic_)
throws EndOfInputException, MalformedRecordException
{
  String line;
  StringTokenizer t = null;
  String clientS, timeS, userS, URLS, sizeS, elapsedS;
  String elapsedSS, elapsedSUS;
  int ii;

  //artificialDynamic = artificialDynamic_;
  sharedProxy = sharedProxy_;

  int ndx;
  int count = 0;

  method = "GET";

  try{
    line = "init";
    while(line.equals("") || line.equals("init")){
      line = in.readLine();
      if(line == null){
	throw new EndOfInputException();
      }
      line = removeQuotes(line);
      t = new StringTokenizer(line);
      count = t.countTokens();
      if(count == 0){
	throw new EndOfInputException();
      }
      if(count != 10){
	System.err.println("bad count " + count + " line was: " + line + " IGNORE LINE");
	line = "init";
	continue ;
      }
      Assert.myAssert(line != null, "Line is NULL");
      Assert.myAssert(count == 10);
      Assert.myAssert(t != null);
      clientS = t.nextToken();
      if(sharedProxy){
	  client = "sharedProxy";
      }
      else{
	  client = clientS;
      }
      
      // dummy nextToken().. 2 -'s
      t.nextToken() ;
      t.nextToken() ;
      
      // some two tokens for time
      timeS = t.nextToken();
      timeS = t.nextToken();
      
      if(t.nextToken().indexOf("GET") < 0){
	  System.err.println("No GET -- line was: " + line + " IGNORE LINE");
	  line = "init";
	  continue ;
      }
      URLS = "http://www.pfnice.edu"+t.nextToken();
      server = getServerFromURL(URLS).toLowerCase();
      objId = getObjIdFromURL(URLS);
      
      if(objId.equals("")){
	  objId = "x?fakeCgi=true";      
      }
      t.nextToken() ;
      squidCode = RawReq.SQUID_TCP_MISS;
    
      sizeS = t.nextToken();
      try{
	  size = (new Integer(sizeS)).intValue();
      }
      catch(NumberFormatException e){
	  throw new MalformedRecordException("Bad Size: " + line 
					     + " size was: " + sizeS);
      }
    }
    return;
  }
  catch(IOException e){
      throw new Error("FatalError: IO Exception " + e);
  }
}

private String removeQuotes(String orig){
  int at = 0, to;
  String ret;
  StringBuffer result = new StringBuffer();

  while(orig.charAt(at) == '\"'){
    at++;
  }
 
  to = orig.indexOf('\"', at);
  while(to != -1){
    Assert.myAssert(to != -1, "Bug 1");
    result.append(orig.substring(at, to));
    at = to + 1;
    to = orig.indexOf('\"', at);
  }
  Assert.myAssert(at != -1, "Bug 2");
  result.append(orig.substring(at));
  ret = result.toString();
  Assert.myAssert(ret.indexOf('\"') == -1);
  return ret;
}
  
}
