/*
 *------------------------------------------------------------------
 *
 * LESS Group 
 * Computer Sciences Department 
 * University of Texas at Austin
 *
 * PendingRequest ---
 *          description.
 *
 * $Date: 2003/01/06 06:16:30 $ $Id: PendingRequest.java,v 1.1.1.1 2003/01/06 06:16:30 ypraveen Exp $
 *
 * Copyright (c) 2002 by Mike Dahlin.
 * 
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for noncommercial use without fee and
 * without written agreement is hereby granted, provided that 
 * the above copyright notice appear in all copies of this software.
 * 
 *------------------------------------------------------------------
 */
public class PendingRequest{
  String objId;
  boolean statusSuccess;
  long start;
  long done = 0;
  long gotSize;
  Object context; // Opaque we just pass it from sender to receiver

public PendingRequest(String objId_, Object rr)
  {
    start = System.currentTimeMillis();
    objId = objId_;
    statusSuccess = false;
    context = rr;
  }
public void launched()
  {
    start = System.currentTimeMillis();
  }
public boolean getStatusSuccess()
  {
    return statusSuccess;
  }

public Object getContext()
  {
    return context;
  }
public void succeeded(long gotSize_)
  {
    done = System.currentTimeMillis();
    statusSuccess = true;
    gotSize = gotSize_;
  }


public void failed()
  {
    done = System.currentTimeMillis();
    statusSuccess = false;
    gotSize = -1;
  }

public String getObjId()
  {
    return objId;
  }

public long getGotSize()
  {
    return gotSize;
  }
public long getTime()
  {
    Assert.myAssert(done != 0);
    return done - start;
  }




}
