/*
 *------------------------------------------------------------------
 *
 * LESS Group 
 * Computer Sciences Department 
 * University of Texas at Austin
 *
 * PredRawReq ---
 *          A RawReq generated from a Prediction.
 *
 * $Date: 2003/01/06 06:16:30 $ $Id: PredRawReq.java,v 1.1.1.1 2003/01/06 06:16:30 ypraveen Exp $
 *
 * Copyright (c) 2002 by Mike Dahlin.
 * 
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for noncommercial use without fee and
 * without written agreement is hereby granted, provided that 
 * the above copyright notice appear in all copies of this software.
 * 
 *------------------------------------------------------------------
 */
public class PredRawReq extends RawReq{


  // !!! DANGER !!!
private float prob;
private final static int nFields = 1;
  // !!! DANGER !!!
  // Don't forget to update toString(), equals(), makeClone(),
  // and makeCloneHelper() if new fields are added.
  //

public float getProb(){
  return prob;
}

public RawReq makeClone()
  {
    PredRawReq r = new PredRawReq();
    this.makeCloneHelper(r); // super-class copies fields
    Assert.myAssert(nFields == 1);
    r.prob = prob;
    return r;
  }

public boolean equals(RawReq r)
  {
    if(!( r instanceof PredRawReq)){
      return false;
    }
    Assert.myAssert(nFields == 1);
    if(((PredRawReq)r).prob != prob){
      return false;
    }
    return this.equalsHelper(r); // Check fields in superclass
  }

  //
  // !!! DANGER: LEAVE IT PRIVATE !!!
  // Used only in makeClone(), which will take care of initializing everything.
private PredRawReq()
  {
  }



public PredRawReq(Prediction p)
  {
    prob = p.getProb();
    sharedProxy = false;
    client = "localhost";
    server = getServerFromURL(p.getURL());
    objId = getObjIdFromURL(p.getURL());
    squidCode = SQUID_TCP_MISS;
    int size = 0;
    long timeMS = 0;
    int resultCode = 0;
    String method = "GET";
  }
};
