/*
 *------------------------------------------------------------------
 *
 * LESS Group 
 * Computer Sciences Department 
 * University of Texas at Austin
 *
 * Prefetcher ---
 *          Issues the async prefetch requests.
 *
 * $Date: 2003/01/06 06:16:30 $ $Id: Prefetcher.java,v 1.1.1.1 2003/01/06 06:16:30 ypraveen Exp $
 *
 * Copyright (c) 2002 by Mike Dahlin.
 * 
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for noncommercial use without fee and
 * without written agreement is hereby granted, provided that 
 * the above copyright notice appear in all copies of this software.
 * 
 *------------------------------------------------------------------
 */
public class Prefetcher{
private Cache cache;
private Stats stats;
private DelayedFetchQ fetchQ;
private final static int MAX_PIPELINE = 2;

public Prefetcher(Cache c, Stats s, float prefThresh, long embargoMS)
  {
    int ii;

    cache = c;
    stats = s;


    String server = RawReq.getPrefetchMangledServer();
    int port = RawReq.getPrefetchMangledPort();
    PerstConnection prefetchConnection = new PerstConnection(server, 
							     port, 
							     MAX_PIPELINE);


    // include prefThresh for lazy filtering
    fetchQ = new DelayedFetchQ(cache, prefThresh, embargoMS); 
    PrefetcherThread requester = new PrefetcherThread(cache, stats, 
						      prefetchConnection, fetchQ,
						      PrefetcherThread.MODE_REQ);
    requester.start();
    PrefetcherThread receiver = new PrefetcherThread(cache, stats, 
						     prefetchConnection, fetchQ,
						     PrefetcherThread.MODE_RECV);
    receiver.start();
    Assert.myAssert(receiver.getPriority() > Thread.MIN_PRIORITY,
		    "I assume default priority > min");
    try{
      Thread.sleep(400); // Let thread get initialized before proceeding
    }
    catch(InterruptedException z){
    }
    //  System.out.println("Note: currently not lower prefetch thread priority");
    requester.setPriority(Thread.MIN_PRIORITY);
    //    receiver.setPriority(Thread.MIN_PRIORITY + 1);
  }


/*
 *------------------------------------------------------------------
 *
 * notifyDemand --
 *
 *    See design.txt.
 *
 *     if a demand request for an html file comes along, delete all 
 *     pending prefetch requests
 *     (See discussion of "when to initate/cancel prefetches" in design.txt.
 *     Our first implementation will just clear the queue to prevent
 *     new prefetches from being issued and it will only have 2
 *     threads so that the already-issued requests won't do too much
 *     damage before they finish.)
 *
 * Arguments:
 *      RawReq r -- the demand request.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
public void notifyDemand(RawReq r)
  {
    if(r.isHTMLOrDynamic()){
      fetchQ.cancelAll();
    }
  }

/*
 *------------------------------------------------------------------
 *
 * asyncFetch --
 *
 *          Enqueue the work in the delayed fetch queue.
 *
 * Arguments:
 *      PredRawReq prefetchList -- list of stuff to prefetch.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      Note: we keep a pointer to the list you hand in.
 *      You are not allowed to change it once you hand it
 *      in.
 *
 *------------------------------------------------------------------
 */
public void asyncFetch(PredRawReq prefetchList[])
  {
    fetchQ.putList(prefetchList);
  }


};
