//import HTTPClient.HttpURLConnection;
//import org.w3c.www.protocol.http.HttpURLConnection;
//import org.w3c.www.protocol.http.HttpException;
import java.io.*;
import java.net.*;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
/*
 *------------------------------------------------------------------
 *
 * LESS Group 
 * Computer Sciences Department 
 * University of Texas at Austin
 *
 * PrefetcherThread ---
 *          Worker thread that makes prefetch fetches happen.
 *          One thread works on sending. One on receiving.
 *
 * $Date: 2003/01/06 06:16:30 $ $Id: PrefetcherThread.java,v 1.1.1.1 2003/01/06 06:16:30 ypraveen Exp $
 *
 * Copyright (c) 2002 by Mike Dahlin.
 * 
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for noncommercial use without fee and
 * without written agreement is hereby granted, provided that 
 * the above copyright notice appear in all copies of this software.
 * 
 *------------------------------------------------------------------
 */
public class PrefetcherThread extends Thread{
private  Cache cache;
private  Stats stats;
private  DelayedFetchQ fetchQ;
private PerstConnection perstConnection;
public final static int MODE_RECV = 10000;
public final static int MODE_REQ = 10001;
private int mode;

public PrefetcherThread(Cache c, Stats s, 
			PerstConnection perstConnection_, DelayedFetchQ q,
			int mode_)
  {
    cache = c;
    stats = s;
    fetchQ = q;
    perstConnection = perstConnection_;
    mode = mode_;
    Assert.myAssert(mode == MODE_REQ || mode == MODE_RECV);
  }

public void run()
  {
    if(mode == MODE_REQ){
      runReq();
    }
    else{
      Assert.myAssert(mode == MODE_RECV);
      runRecv();
    }
  }

private void runReq()
  {
    while(true){
	RawReq r = fetchQ.get();
	String mangledObjId = r.getPrefetchMangledPathOnServer();
	PendingRequest pr = new PendingRequest(mangledObjId, r);
	perstConnection.put(pr); // Limited pipelining applies backpressure
    }
  }


private void runRecv()
  {
    while(true){
      try{
	PendingRequest rply = perstConnection.get(); // Get the next result
	//	System.out.println("Prefetch took " + rply.getTime());
	RawReq r = (RawReq)rply.getContext();
	if(!rply.getStatusSuccess()){
	  stats.prefetchFailed(r, rply.getTime());
	  fetchQ.prefetchDoneUpdateCache(r, cache, false);
	}
	else{
	  if(rply.getGotSize() > 0){
	    r.setSize((int)rply.getGotSize());
	  }
	  stats.prefetchDone(r, rply.getTime());
	  fetchQ.prefetchDoneUpdateCache(r, cache, true);
	}
      }
      catch(Exception e){
	System.out.println("Prefetcher thread got exception " + e + "\n"
			   + "Should we try to continue? For now I just die.");
	e.printStackTrace();
	System.exit(-1);
      }
    }
  }

};




