import java.io.BufferedReader;
import java.util.StringTokenizer;
import java.io.IOException;

public abstract class RawReq{

  //
  // Squid codes. Why wont stinkin java give us enums?
  //
public static final int SQUID_TCP_HIT = 0;
public static final int SQUID_TCP_MEM_HIT = 1;
public static final int SQUID_TCP_MISS = 2;
public static final int SQUID_TCP_REFRESH_HIT = 3;
public static final int SQUID_TCP_REF_FAIL_HIT = 4;
public static final int SQUID_TCP_REFRESH_MISS = 5;
public static final int SQUID_TCP_CLIENT_REFRESH_MISS = 6;
public static final int SQUID_TCP_IMS_HIT = 7;
public static final int SQUID_TCP_IMS_MISS = 8;
public static final int SQUID_TCP_SWAPFILE_MISS = 9;
public static final int SQUID_TCP_DENIED = 10;
public static final int SQUID_TCP_NEGATIVE_HIT = 11; // Cache "knows" request will fail. See squid.conf file
public static final int SQUID_NCODES = 12;

private static boolean mangleInit = false;

private static String demandMangledPrefix = "UNINITIALIZED";
private static String prefetchMangledPrefix = "UNINITIALIZED";
public static int demandManglePort;
public static int prefetchManglePort;
public static String demandMangleServer;
public static String prefetchMangleServer;
public static String demandManglePath;
public static String prefetchManglePath;

private static final String tcpStatusNames[] = {
  "TCP_HIT",
  "TCP_MEM_HIT",
  "TCP_MISS",
  "TCP_REFRESH_HIT",
  "TCP_REF_FAIL_HIT",
  "TCP_REFRESH_MISS",
  "TCP_CLIENT_REFRESH_MISS",
  "TCP_IMS_HIT",
  "TCP_IMS_MISS",
  "TCP_SWAPFAIL_MISS",
  "TCP_DENIED",
  "TCP_NEGATIVE_HIT"
};
  
  // !!! DANGER !!!
  boolean sharedProxy;
  String client;
  String server;
  String objId;
  int squidCode;
  int size;
  long timeMS;
  int resultCode;
  String method;
  final static int nFields = 10;  // Defensive prgramming - update me!
  // !!! DANGER !!!
  // Don't forget to update toString(), equals(), makeClone(),
  // and makeCloneHelper() if new fields are added.
  //

public abstract RawReq makeClone();

protected void makeCloneHelper(RawReq r)
  {
    Assert.myAssert(nFields == 10);
    r.sharedProxy = sharedProxy;
    r.client = client;
    r.server = server;
    r.objId = objId;
    r.squidCode = squidCode;
    r.size = size;
    r.timeMS = timeMS;
    r.resultCode = resultCode;
    r.method = method;
  }

public String toString()
  {
    return new String(timeMS + " " + client + " --> " + " " + method
		      + " " + server + " " + objId
		      + " SquidCode: " + squidCode + " resultCode: " 
		      + resultCode +  " Size: " + size); 
  }

public String getMethod()
  {
    return method;
  }

public int getSize()
  {
    return size;
  }
public void setSize(int s)
  {
    size = s;
  }

public String getClient()
    {
      return client;
    }

public String getServer()
    {
      return server;
    }
public String getObjId()
    {
      if(objId.equals("") || objId.equals("/")){
	return "/index.html";
      }
      if(endsWith(objId, "/")){
	return objId + "index.html";
      }
      if(objId.indexOf(".") == -1){ // Probably a directory
	return objId + "/index.html";
      }
      return objId;
    }
public int getSquidCode()
    {
      return squidCode;
    }
public int getResultCode()
    {
      Assert.myAssert(resultCode >= 0 && resultCode <=999, "bad result code");
      return resultCode;
    }
public long getTimeMS()
    {
      return timeMS;
    }
public void setCorrectedTimeMS(long newTimeMS)
  {
    timeMS = newTimeMS;
  }

public abstract boolean equals(RawReq r);

protected boolean equalsHelper(RawReq r)
  {
    Assert.myAssert(nFields == 10);
    if(method != r.method){
      return false;
    }
    if(size != r.size){
      return false;
    }
    if(!client.equals(r.client)){
      return false;
    }
    if(!server.equals(r.server)){
      return false;
    }
    if(!objId.equals(r.objId)){
      return false;
    }
    if(resultCode != r.resultCode){
      return false;
    }
    if(timeMS != r.timeMS){
      return false;
    }
    if(sharedProxy != r.sharedProxy){
      return false;
    }
    return true;
  }


  // Simple rule: 
  // Anything that ends with .cgi
  //          that contains '?'
  //          that ends with '.asp'
  //          that ends with '.jsp'
  // Is uncachable. Otherwise assume cachable.
public boolean isCachable()
  {
    if(objId.indexOf("?") != -1){
      return false;
    }
    if(objId.indexOf("&") != -1){
      return false;
    }
    if(endsWith(objId, ".cgi")){
      return false;
    }
    if(endsWith(objId, ".asp")){
      return false;
    }
    if(endsWith(objId, ".jsp")){
      return false;
    }
    return true;
  }


public boolean isHTMLOrDynamic()
  {
    return isHTMLOrDynamic(getObjId());
  }


public static boolean isHTMLOrDynamic(String name)
  {
    if(endsWith(name, ".html")){
      return true;
    }
    if(endsWith(name, ".htm")){
      return true;
    }
    if(endsWith(name, ".cgi")){
      return true;
    }
    if(endsWith(name, ".asp")){
      return true;
    }
    if(endsWith(name, ".jsp")){
      return true;
    }
    return false;
  }

protected static boolean endsWith(String objId, String suffix)
  {
    String lowerObjId = objId.toLowerCase();
    suffix = suffix.toLowerCase();

    int ndx = lowerObjId.lastIndexOf(suffix);
    if(ndx == -1){
      return false;
    }
    if(ndx == (lowerObjId.length() - suffix.length())){
      return true;
    }
    return false;
  }


protected static String getServerFromURL(String URLS)
  {
    int ndx;
    String server;

    ndx = URLS.indexOf('/', 7); 
    if(ndx == -1){
      server = URLS;
    }
    else{
      //
      // Strip off the "http://
      //
      server = URLS.substring(7, ndx);
      //
      // If port is :80, strip it off. Otherwise leave it.
      //
      ndx = server.indexOf(":");
      if(ndx != -1){
	if(server.substring(ndx).equals(":80")){
	  server = server.substring(0,ndx);
	}
      }
    }
    return server;
  }

protected static String getObjIdFromURL(String URLS)
  {
    int ndx;
    String objId;
    ndx = URLS.indexOf('/', 7); 
    if(ndx == -1){
      objId = "";
    }
    else{
      objId = URLS.substring(ndx);
    }
    return objId;
  }


/*
 *------------------------------------------------------------------
 *
 * setMangle --
 *
 *     We change URLS into "prefetch URLS" and "demand URLS"
 *     before sending requests across the network where.
 *     a single server simulates one or more servers.
 *
 *     So, if we are running our simulator on orchid.cs.utexas.edu:9000 
 *     and :9001 for demand and prefetch respectively, 
 *     and we have created a bunch of dummy files corresponding
 *     to our trace in the directory "simdir" on orchid.
 *
 *     Then demandManglePrefix is "orchid.cs.utexas.edu:9000/simdir".
 *     When it comes time to actually make a network demand
 *     request for http://foo.com/bar, we will call 
 *     getDemandMangledURL() and this will return
 *     http://orchid.cs.utexas.edu/simdir/foo.com/bar
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */

public static void setMangle(String demand, String pref)
  {
    mangleInit = true;
    if(!endsWith(demandMangledPrefix, "/")){
      demandMangledPrefix = demand + "/";
    }
    else{
      demandMangledPrefix = demand;
    }
    int ndx = demand.indexOf(":");
    if(ndx == -1){
      demandManglePort = 80;
      ndx = demand.indexOf("/");
      demandMangleServer = demand.substring(0,ndx);
    }
    else{
      demandMangleServer = demand.substring(0,ndx);
      int ndx2 = demand.indexOf("/");
      demandManglePort = (new Integer(demand.substring(ndx+1, ndx2))).intValue();
      ndx = ndx2;
    }
    demandManglePath = demand.substring(ndx+1);

      
    if(!endsWith(prefetchMangledPrefix, "/")){
      prefetchMangledPrefix = pref + "/";
    }
    else{
      prefetchMangledPrefix = pref;
    }

    ndx = pref.indexOf(":");
    if(ndx == -1){
      prefetchManglePort = 80;
      ndx = pref.indexOf("/");
      prefetchMangleServer = pref.substring(0,ndx);
    }
    else{
      prefetchMangleServer = pref.substring(0,ndx);
      int ndx2 = pref.indexOf("/");
      prefetchManglePort = (new Integer(pref.substring(ndx+1, ndx2))).intValue();
      ndx = ndx2;
    }
    prefetchManglePath = pref.substring(ndx + 1); 

  }

protected String getDemandMangledURL()
  {
    Assert.myAssert(mangleInit);
    String URL = "http://" + demandMangledPrefix + server + getObjId();
    //    System.out.println("getDemandMangledURL would return: " + URL + " returning http://www.cs.utexas.edu/ instead.");
    //    URL = "http://orchid.cs.utexas.edu:9000/index.html";
    return URL;
  }


protected String getPrefetchMangledURL()
  {
    Assert.myAssert(mangleInit);
    String URL = "http://" + prefetchMangledPrefix + server + getObjId();
    //    System.out.println("getDemandMangledURL would return: " + URL + " returning http://www.cs.utexas.edu/ instead.");
    //    URL = "http://orchid.cs.utexas.edu:9001/index.html";
    return URL;
  }

protected String getDemandMangledPathOnServer()
  {
    return demandManglePath + "/" + server + getObjId();
  }

protected String getPrefetchMangledPathOnServer()
  {
    return prefetchManglePath + "/" + server + getObjId();
  }

protected static String getDemandMangledServer()
  {
    return demandMangleServer;
  }
protected static String getPrefetchMangledServer()
  {
    return prefetchMangleServer;
  }

protected static int getDemandMangledPort()
  {
    return demandManglePort;
  }
protected static int getPrefetchMangledPort()
  {
    return prefetchManglePort;
  }

public static void main(String argv[])
  {
    Assert.myAssert(endsWith("foo.cgi", ".cgi"));
    Assert.myAssert(endsWith("foo.asp", ".asp"));
    Assert.myAssert(!endsWith("foo.cgi", ".asp"));
    System.out.println("Pass test 0.");

    Assert.myAssert(getObjIdFromURL("http://www.cs.utexas.edu/users/dahlin").equals("/users/dahlin"));
    Assert.myAssert(getServerFromURL("http://www.cs.utexas.edu/users/dahlin").equals("www.cs.utexas.edu"));
    Assert.myAssert(getServerFromURL("http://www.cs.utexas.edu:80/users/dahlin").equals("www.cs.utexas.edu"));
    Assert.myAssert(getServerFromURL("http://www.cs.utexas.edu:8080/users/dahlin").equals("www.cs.utexas.edu:8080"));
    System.out.println("Pass test 1.");
  }
}
