import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.*;

/*
 *------------------------------------------------------------------
 *
 * LESS Group 
 * Computer Sciences Department 
 * University of Texas at Austin
 *
 * ServerPopulator ---
 *          Create a bunch of dummy files of the specified
 *          trace in a specified directory.
 *
 * $Date: 2003/01/06 06:16:30 $ $Id: ServerPopulator.java,v 1.1.1.1 2003/01/06 06:16:30 ypraveen Exp $
 *
 * Copyright (c) 2002 by Mike Dahlin
 * 
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for noncommercial use without fee and
 * without written agreement is hereby granted, provided that 
 * the above copyright notice appear in all copies of this software.
 * 
 *------------------------------------------------------------------
 */
public class ServerPopulator{
/*
 * Globals set by arguments
 */
private static String client = "UNINITIALIZED";
private static String server = "UNINITIALIZED";
private static String traceFormat = "UNINITIALIZED";
private static Cache cache = new Cache();
private static InputTrace input;
private static String outputDir;
private static final int DEFAULT_SIZE = 4096;

private static Runtime runtime = Runtime.getRuntime();

public static void main(String argv[])
  {
    int c;

    final int MAX_OPT = 4;
    final int REQUIRED_COUNT = 4;
    int gotCount = 0;
    LongOpt[] longopts = new LongOpt[MAX_OPT];

    longopts[0] = new LongOpt("client", LongOpt.REQUIRED_ARGUMENT, 
			      null, 0);
    longopts[1] = new LongOpt("server", LongOpt.REQUIRED_ARGUMENT, 
			      null, 1);
    longopts[2] = new LongOpt("traceFormat", LongOpt.REQUIRED_ARGUMENT, 
			      null, 2);
    longopts[3] = new LongOpt("outputDir", LongOpt.REQUIRED_ARGUMENT, 
			      null, 3);
    Getopt g = new Getopt("ServerPopulator", argv, "", longopts, true);
    while((c = g.getopt()) != -1){
      switch(c){
      case 0:
	client = g.getOptarg();
	gotCount++;
	break;
      case 1:
	server = g.getOptarg();
	gotCount++;
	break;
      case 2:
	traceFormat = g.getOptarg();
	Assert.myAssert(traceFormat.equals("bu")||traceFormat.equals("squid"),
		      "-traceFormat must be 'bu' or 'squid'");
	gotCount++;
	break;
      case 3:
	outputDir = g.getOptarg();
	// Not logically part o RawReq, but it is useful
	// functionality and I'm too lazy to move it to
	// a separate StringUtil class... Sorry.
	if(!RawReq.endsWith(outputDir, "/")){
	  outputDir = outputDir + "/";
	}
	gotCount++;
	break;
     case '?':
	System.out.println("The option '" + (char)g.getOptopt() 
			   + "' is not valid.");
	System.exit(-1);
	break;
      default:
	System.out.println("getopt() returned " + c);
	System.exit(-1);
	break;
      }
    }

    printArgs(argv);

    if(gotCount < REQUIRED_COUNT){
      System.out.println("Missing a required argument. Exiting.");
      System.exit(-1);
    }

    doIt();
    
  }

/*
 *------------------------------------------------------------------
 *
 * doIt --
 *
 *          description.
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
private static void doIt()
  {
    RawReq req;
    int count = 0;
    try{
      //      System.out.println("Putting files in " + outputDir);
      File base = new File(outputDir);
      if(base.exists()){
	Assert.myAssert(base.isDirectory());
      }
      else{
	base.mkdir();
      }
      InputTrace inputTrace = new InputTrace(System.in, traceFormat,
					     client, server, (float)1000000);
      while(true){
	req = inputTrace.nextNoWait();
	count++;
	if(count % 100 == 0){
	  System.out.print(".");
	}
	if(!cache.isCached(req)){
	  makeDummyFile(req);
	  //
	  // Also make the links for UselessPrefetchPredictor
	  makeDummyLinks(req, UselessPrefetchPredictor.N_PRED_PER_URL);
	 }
	 cache.insertIgnoreCachability(req);
       }
     }
     catch(EndOfInputException e){
       System.out.println("Done.");
     }
     catch(MalformedRecordException m){
       System.out.println("Bad record in input: " + m.toString());
       System.exit(-1);
     }
     catch(RuntimeException z){
       System.out.println("Runtime exception: " + z.toString());
       z.printStackTrace();
       System.exit(-1);
     }
     catch(IOException io){
       System.out.println("IOException: " + io.toString());
       io.printStackTrace();
       System.exit(-1);
     }


   }



 /*
  *------------------------------------------------------------------
  *
  * makeDummyFile --
  *
  *      Make a dummy file of the correct size
  *
  * Arguments:
  *      type1 arg1 -- description.
  *
  * Results:
  *      None.
  *
  * Side effects:
  *      None.
  *
  *------------------------------------------------------------------
  */
 private static void makeDummyFile(RawReq r)
   throws IOException
   {
     String path = null;
     try{
       int size = r.getSize();
       if(size <= 0){
	 size = DEFAULT_SIZE;
       }
       path = makePath(r);
       File f = new File(path);
       if(!f.exists()){
	 System.out.println("Creating file " + path);
	 makeParentDirectories(path);
	 f.createNewFile();
	 FileOutputStream fos = new FileOutputStream(f);
	 writeBytes(fos, size);
       }
     }
     catch(IOException e){
       System.out.println("Exception in makeDummyFile: " 
			  + r.toString() + " path: " + path);
     }
   }


/*
 *------------------------------------------------------------------
 *
 * makeDummyLinks --
 *
 *          Make nlinks symbolic links to the file
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
private static void makeDummyLinks(RawReq rr, int nlinks)
throws IOException
  {
    int ii;
    int ndx = rr.getObjId().lastIndexOf('/');
    String fileNameNoDir = rr.getObjId().substring(ndx+1);
    for(ii = 0; ii < nlinks; ii++){
      RawReq clone = rr.makeClone();
      String newObjName = UselessPrefetchPredictor.makeNewObjName(rr, ii);
      String newPath = makePathObjName(rr.getServer(), newObjName);
      makeLink(fileNameNoDir, newPath);
    }
  }


/*
 *------------------------------------------------------------------
 *
 * makeLink --
 *
 *          Make a symbolic link from link to target
 *
 * Arguments:
 *      String target
 *      String link
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
private static void makeLink(String target, String link)
  throws IOException
  {
    File f = new File(link);
    if(!f.exists()){
      System.out.println("Linking "  + target + " to " + link);
      runtime.exec("ln -s " + target + " " + link);
    }
  }

/*
 *------------------------------------------------------------------
 *
 * makePathToFile --
 *
 *          description.
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
private static void makeParentDirectories(String path)
throws IOException
  {
    String parentPath = chopPath(path);
    File f = new File(parentPath);
    if(!f.exists()){
      makeParentDirectories(parentPath);
      f.mkdir();
    }
  }


/*
 *------------------------------------------------------------------
 *
 * chopPath --
 *
 *          description.
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
private static String chopPath(String path)
  {
    int ndx = path.lastIndexOf('/');
    String parent = path.substring(0,ndx);
    // Cannot quite make the following assertion. There
    // are some URLs that include "//" somehwere in the body
    // e.g.,
    // apache-test/htdocs/squid/info.netscape.com/fwd/sidusnews/http://dailynews.netscape.com}
    //
    //    Assert.myAssert(!RawReq.endsWith(parent, "/"), 
    //		    "chopPath: {" + path + "} parent: {" + parent + "}");
    return parent;
  }



/*
 *------------------------------------------------------------------
 *
 * makePath --
 *
 *          Make a pathname
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
private static String makePath(RawReq r)
  {
    String server = r.getServer();
    String objId = r.getObjId();
    return makePathObjName(server, objId);
  }

/*
 *------------------------------------------------------------------
 *
 * makePathObjName --
 *
 *          Make a pathname given an object name and server name
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
private static String makePathObjName(String server, String objId)
  {
    return outputDir + server + objId;
  }




/*
 *------------------------------------------------------------------
 *
 * writeBytes --
 *
 *          description.
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
private static final int BUF_SIZE = 8192;
private static byte buffer[] = new byte[BUF_SIZE];
private static boolean init = false;
private static String dat = "<P>All work and no play makes jack a dull boy.</P>\n";
private static void writeBytes(FileOutputStream fos, int length)
  throws IOException
  {
    if(!init){
      initBuffer();
    }
    while(length >= BUF_SIZE){
      fos.write(buffer);
      length = length - BUF_SIZE;
    }
    fos.write(buffer, 0, length);
  }

private static void initBuffer()
  {
    int ii;
    byte[] b = dat.getBytes();
    int length = 0;
    while(length + b.length <= BUF_SIZE){
      for(ii = 0; ii < b.length; ii++){
	buffer[length+ii] = b[ii];
      }
      length += b.length;
    }
  }

/*
 *------------------------------------------------------------------
 *
 * printArgs --
 *
 *          Print out the arguments we were called with.
 *
 * Arguments:
 *      String argv[]
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
private static void printArgs(String argv[])
  {
    int ii;
    System.out.print("ServerPopulator ");
    for(ii = 0; ii < argv.length; ii++){
      System.out.print(argv[ii] + " ");
    }
    System.out.println("");
  }


};
