import java.io.BufferedReader;
import java.util.StringTokenizer;
import java.io.IOException;

public class SquidRawReq extends RawReq{
private static final String tcpStatusNames[] = {
  "TCP_HIT",
  "TCP_MEM_HIT",
  "TCP_MISS",
  "TCP_REFRESH_HIT",
  "TCP_REF_FAIL_HIT",
  "TCP_REFRESH_MISS",
  "TCP_CLIENT_REFRESH_MISS",
  "TCP_IMS_HIT",
  "TCP_IMS_MISS",
  "TCP_SWAPFAIL_MISS",
  "TCP_DENIED",
  "TCP_NEGATIVE_HIT"
};

  
  // !!! DANGER !!!
private String hierS;
private final static int nFields = 1;
  // !!! DANGER !!!
  // Don't forget to update toString(), equals(), and makeClone()
  // if new fields are added.
  //
public RawReq makeClone()
  {
    SquidRawReq r = new SquidRawReq();
    this.makeCloneHelper(r);  // Super-class copies fields
    Assert.myAssert(nFields == 1);
    r.hierS = hierS;
    return r;
  }
public boolean equals(RawReq r)
  {
    if(!(r instanceof SquidRawReq)){
      return false;
    }
    Assert.myAssert(nFields == 1);
    if(((SquidRawReq)r).hierS != hierS){
      return false;
    }
    return this.equalsHelper(r); // Check fields in superclass
  }

  //
  // Used only in makeClone(), which will take care of initializing everything.
  //
private SquidRawReq()
  {
  }

public String getHier(){
  return hierS;
}

public SquidRawReq(BufferedReader in, boolean sharedProxy)
throws EndOfInputException, MalformedRecordException
{
  String line = "<line to be read>";
  StringTokenizer t;
  String timeS, elapsedS, clientS, tagCodeS, sizeS, methodS, URLS, userS, typeS;
  String squidTag;
  String timeSS, timeSMS;
  String resultCodeS;
  int ii;

  int count;
  int ndx;
   try{
    line = in.readLine();
    if(line == null){
      throw new EndOfInputException();
    }
    Assert.myAssert(line != null, "Line is NULL");
    t = new StringTokenizer(line);
    count = t.countTokens();
    if(count == 0){
      throw new EndOfInputException();
    }
    if(count != 10){
      throw new MalformedRecordException("bad count " + count + " line was: " + line);
    }
    timeS = t.nextToken();
    ndx = timeS.indexOf('.');
    if(ndx < 0){
      throw new MalformedRecordException("Bad time");
    }
    timeSS = timeS.substring(0, ndx);
    timeSMS = timeS.substring(ndx+1);
    timeMS = Long.parseLong(timeSS) * 1000 + Long.parseLong(timeSMS);


    elapsedS = t.nextToken();

    clientS = t.nextToken();
    if(sharedProxy){
      client = "sharedProxy";
    }
    else{
      client = clientS;
    }

    tagCodeS = t.nextToken();
    ndx = tagCodeS.indexOf('/');
    if(ndx < 0){
      throw new MalformedRecordException("bad tag code");
    }
    squidTag = tagCodeS.substring(0, ndx);
    squidCode = -1;
    for(ii = 0; ii < SQUID_NCODES; ii++){
      if(squidTag.equals(tcpStatusNames[ii])){
	squidCode = ii;
	break;
      }
    }
    if(squidCode < 0){
      throw new MalformedRecordException("Bad code " + squidCode + " " + squidTag);
    }
    resultCodeS = tagCodeS.substring(ndx + 1);
    resultCode = Integer.parseInt(resultCodeS);
    if(resultCode < 0 || resultCode > 999){
      throw new MalformedRecordException("Bad result code: " + line 
					 + " CODE WAS: " + resultCode);
    }
      
    

    sizeS = t.nextToken();
    try{
      size = (new Integer(sizeS)).intValue();
    }
    catch(NumberFormatException e){
      throw new MalformedRecordException("Bad Size: " + line 
					 + " size was: " + sizeS);
    }

    methodS = t.nextToken();
    method = methodS;

    URLS = t.nextToken();
    server = getServerFromURL(URLS).toLowerCase();
    objId = getObjIdFromURL(URLS);


    userS = t.nextToken();
    hierS = t.nextToken();
    hierS = hierS.substring(0, hierS.indexOf('/'));
    typeS = t.nextToken();
   }
   catch(IOException e){
     throw new Error("FatalError: IO Exception " + e);
   }
   catch(IndexOutOfBoundsException f){
     throw new MalformedRecordException("Index out of bounds error (substring?): " + line);
   }
}

}
