/*
 *------------------------------------------------------------------
 *
 * LESS Group 
 * Computer Sciences Department 
 * University of Texas at Austin
 *
 * Stats ---
 *          Keeps track of stats.
 *
 *          Synchronized to allow multi-threaded access.
 *
 * $Date: 2003/01/06 06:16:31 $ $Id: Stats.java,v 1.1.1.1 2003/01/06 06:16:31 ypraveen Exp $
 *
 * Copyright (c) 2002 by Mike Dahlin.
 * 
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for noncommercial use without fee and
 * without written agreement is hereby granted, provided that 
 * the above copyright notice appear in all copies of this software.
 * 
 *------------------------------------------------------------------
 */
public class Stats{
private int missCount = 0;
private int missCachableCount = 0;
private int missUncachableCount = 0;
private int hitCount = 0;
private int prefetchCount = 0;
private long missSize = 0;
private long missCachableSize = 0;
private long missUncachableSize = 0;
private long hitSize = 0;
private long totalDemandMS = 0;
private int demand1to10 = 0;
private int demand10to100 = 0;
private int demand100to1000 = 0;
private int demand1000to10000 = 0;
private int demand10000plus = 0;
private long totalDemandBytes = 0;
private long totalPrefetchMS = 0;
private int prefetch1to10 = 0;
private int prefetch10to100 = 0;
private int prefetch100to1000 = 0;
private int prefetch1000to10000 = 0;
private int prefetch10000plus = 0;
private long totalPrefetchBytes = 0;
private int totalDemandFailedCount = 0;
private long totalDemandFailedMS = 0;
private int totalPrefetchFailedCount  = 0;
private long totalPrefetchFailedMS = 0;

public Stats()
  {
  }

public synchronized void incrementMiss(RawReq r)
  {
    missCount++;
    missSize += r.getSize();
    if(r.isCachable()){
      missCachableCount++;
      missCachableSize += r.getSize();
    }
    else{
      missUncachableCount++;
      missUncachableSize += r.getSize();
    }
  }

public synchronized void incrementHit(RawReq r)
  {
    hitCount++;
    hitSize += r.getSize();
  }

public synchronized void demandFetchDone(RawReq r, long elapsedMS)
  {
    totalDemandMS += elapsedMS;
    totalDemandBytes += r.getSize();
    if(elapsedMS < 10){
      demand1to10++;
    }
    else if(elapsedMS < 100){
      demand10to100++;
    }
    else if(elapsedMS < 1000){
      demand100to1000++;
    }
    else if(elapsedMS < 10000){
      demand1000to10000++;
    }
    else{
      demand10000plus++;
    }
  }

public synchronized void prefetchDone(RawReq r, long elapsedMS)
  {
    prefetchCount++;
    totalPrefetchMS += elapsedMS;
    totalPrefetchBytes += r.getSize();
    if(elapsedMS < 10){
      prefetch1to10++;
    }
    else if(elapsedMS < 100){
      prefetch10to100++;
    }
    else if(elapsedMS < 1000){
      prefetch100to1000++;
    }
    else if(elapsedMS < 10000){
      prefetch1000to10000++;
    }
    else{
      prefetch10000plus++;
    }
  }

public synchronized void demandFetchFailed(RawReq r, long elapsedMS)
  {
    totalDemandFailedCount ++;
    totalDemandFailedMS += elapsedMS;
  }
public synchronized void prefetchFailed(RawReq r, long elapsedMS)
  {
    totalPrefetchFailedCount ++;
    totalPrefetchFailedMS += elapsedMS;
  }

public synchronized void done()
  {
    System.out.println("Stats hitCount: " + hitCount);
    System.out.println("Stats hitSize: " + hitSize);
    System.out.println("Stats missCount: " + missCount);
    System.out.println("Stats    missCount-cachable: " + missCachableCount);
    System.out.println("Stats    missCount-uncachable: " + missUncachableCount);
    System.out.println("Stats missSize: " + missSize);
    System.out.println("Stats    missSize-cachable: " + missCachableSize);
    System.out.println("Stats    missSize-uncachable: " + missUncachableSize);
    System.out.println("Stats missSize: " + missSize);
    System.out.println("Stats demandMS: " + totalDemandMS);
    System.out.println("Stats    0-9  : " + demand1to10);
    System.out.println("Stats   10-100: " + demand10to100);
    System.out.println("Stats 100-1000: " + demand100to1000);
    System.out.println("Stats 1000-10000: " + demand1000to10000);
    System.out.println("Stats   10000+: " + demand10000plus);
    System.out.println("Stats demandBytes: " + totalDemandBytes);
    System.out.println("Stats prefetchCount: " + prefetchCount);
    System.out.println("Stats prefetchMS: " + totalPrefetchMS);
    System.out.println("Stats    0-9  : " + prefetch1to10);
    System.out.println("Stats   10-100: " + prefetch10to100);
    System.out.println("Stats 100-1000: " + prefetch100to1000);
    System.out.println("Stats 1000-10000: " + prefetch1000to10000);
    System.out.println("Stats   10000+: " + prefetch10000plus);
    System.out.println("Stats prefetchBytes: " + totalPrefetchBytes);
    System.out.println("Stats failedDemandFetches: " + totalDemandFailedCount);
    System.out.println("Stats failedDemandMS: " + totalDemandFailedMS);
    System.out.println("Stats failedPrefetches: " + totalPrefetchFailedCount);
    System.out.println("Stats failedPrefetchMS: " + totalPrefetchFailedMS);

    System.out.println("Stats: TBD -- stats do not account for pipelinin");
  }
};
