/*
 *------------------------------------------------------------------
 *
 * LESS Group 
 * Computer Sciences Department 
 * University of Texas at Austin
 *
 * UselessPrefetchPredictor ---
 *          Given a request, decide what, if anything, should
 *          be prefetched once this request has been fetched.
 *
 * $Date: 2003/01/06 06:16:31 $ $Id: UselessPrefetchPredictor.java,v 1.1.1.1 2003/01/06 06:16:31 ypraveen Exp $
 *
 * Copyright (c) 2002 by Mike Dahlin.
 * 
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for noncommercial use without fee and
 * without written agreement is hereby granted, provided that 
 * the above copyright notice appear in all copies of this software.
 * 
 *------------------------------------------------------------------
 */
public class UselessPrefetchPredictor implements PrefetchPredictor{

protected final static int N_PRED_PER_URL = 10;
protected final static String URL_SUFFIX = "-uselessPrefetch-";
protected final static float PRED_PROB = (float)1.0;

public UselessPrefetchPredictor()
  {
  }


public synchronized PredRawReq[] getList(RawReq r)
  {
    int ii;
    PredRawReq ret[] = new PredRawReq[N_PRED_PER_URL];
    for(ii = 0; ii < N_PRED_PER_URL; ii++){
      String url = makeNewURL(r, ii);
      ret[ii] = new PredRawReq(new Prediction(url, PRED_PROB));
    }
    return ret;
  }

private static String makeNewURL(RawReq r, int ii)
  {
    String newObjName = makeNewObjName(r, ii);
    String ret = "http://" + r.getServer() + newObjName;
    return ret;
  }

/*
 *------------------------------------------------------------------
 *
 * makeNewObjName --
 *
 *          objName.suffix --> objName-uselessPrefetch-[ii].suffix
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
protected static String makeNewObjName(RawReq r, int ii)
  {
    String objName = r.getObjId();
    int ndx = objName.lastIndexOf('.');
    String start = objName.substring(0, ndx);
    String end = objName.substring(ndx);
    String ret = start + URL_SUFFIX + ii + end;
    return ret;
  }


}
