import java.util.*;
import java.io.*;
import com.quiotix.html.parser.*;
import com.quiotix.html.parser.HtmlDocument.Attribute;
import com.quiotix.html.parser.HtmlDocument.AttributeList;

/** 
 * Example visitor to dump out the links from an HTML document.
 *
 * @author Brian Goetz, Quiotix
 */

public class PFMunger extends HtmlVisitor {

    protected PrintWriter out;
    public int isOnLoad = 0 ;

    public String demandServerName ;
    public String prefetchServerName ;
    public String inputFileName  ;

    public int inHeadNow = 0 ;
    public int headExists = 0 ;
    public int htmlTagExists = 0 ;

    public Vector fileVec ;

    public int roundNum ; // round 0 --> just check if Head is present, if Base is present, etc.,
                          // round 1 --> change things
    
    public PFMunger(OutputStream os)     { 
	out = new PrintWriter(os); 
	fileVec = new Vector() ;
    }

    public PFMunger() {
	out = null ;
	fileVec = new Vector() ;
    }
    
    public PFMunger(OutputStream os, String encoding)
	throws UnsupportedEncodingException {
	out = new PrintWriter( new OutputStreamWriter(os, encoding) );
	fileVec = new Vector() ;
    }
    
    public void finish() { 
	out.flush() ;
	if(roundNum == 1) {
	    System.out.print(inputFileName) ;
	    for(int ii = 0 ; ii < fileVec.size() ; ii++) {
		String file = (String)fileVec.elementAt(ii) ;
		System.out.print(" "+file) ;
	    }
	    System.out.println() ;
	}
    }
    
    public void start() { 
	// in case you want to change the doc.domain, change it here!
	if(roundNum == 1 && headExists == 0) {
	    out.print("<HEAD>\n"+
		      "<BASE href=\"http://"+demandServerName+
			  "/"+inputFileName+"\">\n"+
		      "</HEAD>\n") ;
	}
    }
    
    // public void visit(HtmlDocument.Tag t)        { out.print(t);   }
    public void visit(HtmlDocument.EndTag t)     { 
	if(roundNum == 1) { 
	    out.print(t);   
	}
	else if(roundNum == 0) {
	    if(t.tagName.equalsIgnoreCase("HEAD")) {
		inHeadNow = 0 ;
	    }
	}
    }
    public void visit(HtmlDocument.Comment c)  { 
	if(roundNum == 1) { 
	    out.print(c);   
	}
    }  
    public void visit(HtmlDocument.Text t)    { 
	if(roundNum == 1) { 
	    out.print(t);   
	}
    }   
    public void visit(HtmlDocument.Newline n)   { 
	if(roundNum == 1) { 
	    out.print(n);   
	}
    } 
    public void visit(HtmlDocument.Annotation a) { 
	if(roundNum == 1) { 
	    out.print(a);   
	}
    }
    
    public void visit(HtmlDocument.Tag t) { 
	int found = 0 ;
	StringBuffer oldname ;
	int start ;
	if(roundNum == 1) {
	    if (t.tagName.equalsIgnoreCase("IMG")) {
		for (Iterator i=t.attributeList.attributes.iterator(); i.hasNext(); ) {
		    Attribute a = (Attribute) i.next();
		    if (a.name.equalsIgnoreCase("src")) {
			//System.out.println(deQuote(a.value));
			oldname = new StringBuffer(a.value) ;
			
			if((start = oldname.toString().indexOf("http://" + demandServerName)) != -1) {
			    //System.out.println(deQuote(oldname.toString()).substring(start + 7 + demandServerName.length())) ;
			    fileVec.add(deQuote(oldname.toString()).substring(start + 7 + demandServerName.length())) ;
			    oldname.replace(start, start + 7 + demandServerName.length(),
					    "http://" + prefetchServerName);
			}
			else if((start = oldname.toString().indexOf("http://")) == -1) {
			    oldname.replace(1,1,
					    "http://" + prefetchServerName+"/");
			    fileVec.add(deQuote(a.value));
			}
			a.value = oldname.toString();
		    }
		}
		out.print(t) ;
	    }
	    else if(t.tagName.equalsIgnoreCase("head")) {
		out.print(t) ;
		out.print("\n<BASE href=\"http://"+demandServerName+
			  "/"+inputFileName+"\">") ;
		//out.flush() ;
	    }
	    else {
		out.print(t) ;
	    }
	}
	else if(roundNum == 0) {
	    if(t.tagName.equalsIgnoreCase("head")) {
		inHeadNow = 1 ;
		headExists = 1;
	    }
	    else if(t.tagName.equalsIgnoreCase("base") && inHeadNow == 1) {
		System.out.println("HECK--I do not work");
		System.exit(0) ;
	    }
	}
    }

    public static String deQuote(String s) {
	if (s.startsWith("\"") && s.endsWith("\""))
	    return s.substring(1, s.length() - 1);
	else
	    return s;
    }
    
    public static void main (String args[]) throws ParseException, IOException {
	HtmlDocument document;
	InputStream inp = null ;

	PFMunger pfm = new PFMunger() ;

	// syntax : java PFMunger <demandServerName> <prefetchServerName> <fileName(OPT)>
	if(args.length < 2){
	    System.out.println("Usage: "+
			       "java PFMunger <demandServerName> <prefetchServerName> <dataDir (compulsory if next ones are given)> <inputfileName (OPT) > <outputfileName(OPT)>");
	}
	pfm.demandServerName = args[0] ;
	pfm.prefetchServerName = args[1] ;
	
	if(args.length > 3) {
	    if(args[2].compareTo(new String ("./")) != 0)
		pfm.inputFileName = args[2] ; // for base
	    else {
		pfm.inputFileName = new String("") ;
	    }
	    inp = new FileInputStream(args[3]) ;
	}
	else {
	    pfm.inputFileName = new String("") ;
	    inp = System.in ;
	}

	if(args.length > 4) {
	    pfm.out = new PrintWriter(new FileOutputStream(args[4]), true) ;
	}
	else {
	    pfm.out = new PrintWriter(System.out, true) ;
	}
	
	//System.out.println(new Date().getTime());
	document = new HtmlParser(inp).HtmlDocument();
	//System.out.println(new Date().getTime());

	pfm.roundNum = 0 ;
	document.accept(pfm);
	
	pfm.roundNum = 1 ;
	document.accept(pfm);

	//System.out.println(new Date().getTime());
    }
}



