#!/lusr/bin/perl
use File::Find;
use File::Basename;

$demandservername = $ARGV[0];
$prefetchservername = $ARGV[1];
$indirectory = $ARGV[2];
$path = $ARGV[3];

$indirlength = length $indirectory;

# Issue the find command passing two arguments
# The first argument is the subroutine that will be called for each file in the path.
# The second argument is the directory to start your search in.
find(\&inline_lister, "$indirectory");

sub inline_lister {
    my $file = $File::Find::name ; 
    if(index($file,$prefetchservername) == -1) {	    
	# print "$file\n";
	# open(IN, "<$file") or die "File $file couldn't be opened"; 
	# strip off indirectory from the filename
	$pathfile = $path."/".$file;
	$newfile = substr($file,$indirlength);
	$basepath = dirname($newfile)."/";
	$outputfilename = $path."/".$prefetchservername."/".$newfile;
	$dirname = $path."/".$prefetchservername."/".dirname($newfile);
	print ("mkdir -p $dirname\n");
	system("mkdir -p $dirname");
	
	if ((/\.html$/) || (/\.htm$/)||(/\.shtml$/)) {
	    system("touch $outputfilename");
	    print ("java -classpath $path PFMunger $demandservername $prefetchservername $basepath $pathfile $outputfilename\n");
	    system("java -classpath $path PFMunger $demandservername $prefetchservername $basepath $pathfile $outputfilename");
	    
	}
	else {
	    # Non html - Just copy the file
	    system("cp $pathfile $outputfilename");
	}
    }
}

