/*
 * Decompiled with CFR 0.152.
 */
package rcssjava;

import java.io.Serializable;
import rcssjava.Utils;

public class VecPosition
implements Serializable {
    private double m_x;
    private double m_y;

    public VecPosition() {
        this(0.0, 0.0);
    }

    public VecPosition(double d, double d2) {
        this(d, d2, false);
    }

    public VecPosition(double d, double d2, boolean bl) {
        if (bl) {
            VecPosition vecPosition = VecPosition.getVecPositionFromPolar(d, d2);
            this.m_x = vecPosition.getX();
            this.m_y = vecPosition.getY();
        } else {
            this.m_x = d;
            this.m_y = d2;
        }
    }

    public VecPosition(VecPosition vecPosition) {
        this(vecPosition.getX(), vecPosition.getY());
    }

    public void copy(VecPosition vecPosition) {
        this.m_x = vecPosition.getX();
        this.m_y = vecPosition.getY();
    }

    public double getX() {
        return this.m_x;
    }

    public double getY() {
        return this.m_y;
    }

    public double getMagnitude() {
        return Math.sqrt(this.m_x * this.m_x + this.m_y * this.m_y);
    }

    public double getDirection() {
        return Utils.atan2Deg(this.m_y, this.m_x);
    }

    public double getDistanceTo(VecPosition vecPosition) {
        return this.subtract(vecPosition).getMagnitude();
    }

    public boolean isInFrontOf(double d) {
        return this.m_x > d;
    }

    public boolean isInFrontOf(VecPosition vecPosition) {
        return this.m_x > vecPosition.m_x;
    }

    public boolean isBehind(double d) {
        return this.m_x < d;
    }

    public boolean isBehind(VecPosition vecPosition) {
        return this.m_x < vecPosition.m_x;
    }

    public boolean isLeftOf(double d) {
        return this.m_y < d;
    }

    public boolean isLeftOf(VecPosition vecPosition) {
        return this.m_y < vecPosition.m_y;
    }

    public boolean isRightOf(double d) {
        return this.m_y > d;
    }

    public boolean isRightOf(VecPosition vecPosition) {
        return this.m_y > vecPosition.m_y;
    }

    public boolean isBetweenX(VecPosition vecPosition, VecPosition vecPosition2) {
        return this.isBetweenX(vecPosition.getX(), vecPosition2.getX());
    }

    public boolean isBetweenX(double d, double d2) {
        return this.isInFrontOf(d) && this.isBehind(d2) || this.m_x == d || this.m_x == d2;
    }

    public boolean isBetweenY(VecPosition vecPosition, VecPosition vecPosition2) {
        return this.isBetweenY(vecPosition.getY(), vecPosition2.getY());
    }

    public boolean isBetweenY(double d, double d2) {
        return this.isRightOf(d) && this.isLeftOf(d2) || this.m_y == d || this.m_y == d2;
    }

    public VecPosition negate() {
        return new VecPosition(-this.m_x, -this.m_y);
    }

    public VecPosition add(double d) {
        return new VecPosition(this.m_x + d, this.m_y + d);
    }

    public VecPosition add(VecPosition vecPosition) {
        return new VecPosition(this.m_x + vecPosition.m_x, this.m_y + vecPosition.m_y);
    }

    public VecPosition subtract(double d) {
        return new VecPosition(this.m_x - d, this.m_y - d);
    }

    public VecPosition subtract(VecPosition vecPosition) {
        return new VecPosition(this.m_x - vecPosition.m_x, this.m_y - vecPosition.m_y);
    }

    public VecPosition multiply(double d) {
        return new VecPosition(this.m_x * d, this.m_y * d);
    }

    public VecPosition multiply(VecPosition vecPosition) {
        return new VecPosition(this.m_x * vecPosition.m_x, this.m_y * vecPosition.m_y);
    }

    public VecPosition divide(double d) {
        return new VecPosition(this.m_x / d, this.m_y / d);
    }

    public VecPosition divide(VecPosition vecPosition) {
        return new VecPosition(this.m_x / vecPosition.m_x, this.m_y / vecPosition.m_y);
    }

    public VecPosition withMagnitude(double d) {
        if (this.getMagnitude() > 1.0E-5) {
            return this.multiply(d / this.getMagnitude());
        }
        return new VecPosition(this.getX(), this.getY());
    }

    public VecPosition normalize() {
        return this.withMagnitude(1.0);
    }

    public VecPosition rotate(double d) {
        double d2 = this.getMagnitude();
        double d3 = this.getDirection() + d;
        return new VecPosition(d2, d3, true);
    }

    public VecPosition globalToRelative(VecPosition vecPosition, double d) {
        return this.subtract(vecPosition).rotate(-d);
    }

    public VecPosition relativeToGlobal(VecPosition vecPosition, double d) {
        return this.rotate(d).add(vecPosition);
    }

    public double dotProduct(VecPosition vecPosition) {
        VecPosition vecPosition2 = this.multiply(vecPosition);
        return vecPosition2.getX() + vecPosition2.getY();
    }

    public double getAngleBetweenPoints(VecPosition vecPosition, VecPosition vecPosition2) {
        VecPosition vecPosition3 = this.subtract(vecPosition).normalize();
        VecPosition vecPosition4 = this.subtract(vecPosition2).normalize();
        return Math.abs(Utils.acosDeg(vecPosition3.dotProduct(vecPosition4)));
    }

    public String toString() {
        return "( " + this.m_x + ", " + this.m_y + " )";
    }

    public static VecPosition getVecPositionFromPolar(double d, double d2) {
        return new VecPosition(d * Utils.cosDeg(d2), d * Utils.sinDeg(d2));
    }
}

