/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.coach;

import java.io.BufferedReader;
import java.io.FileReader;
import rcssjava.ServerParams;
import rcssjava.WorldState;
import rcssjava.comm.CoachCommandHandler;
import rcssjava.comm.Connection;
import rcssjava.comm.RCSSParser;

public class CLangSender {
    ServerParams SP = new ServerParams();
    WorldState WS = new WorldState(this.SP);
    CoachCommandHandler CMD;
    Connection C;
    RCSSParser parser;
    String teamName;
    String clangFile;

    public CLangSender(Connection connection, String string, String string2) {
        this.C = connection;
        this.CMD = new CoachCommandHandler(this.C, this.WS);
        this.parser = new RCSSParser(this.WS, this.SP);
        this.teamName = string;
        this.clangFile = string2;
    }

    public void mainLoop() {
        this.CMD.init(this.teamName, 9.0);
        String string = this.C.receive();
        this.parser.analyzeMessage(string);
        if (this.WS.getOurSide() == -1) {
            System.err.println("Unable to init: " + string);
            System.exit(1);
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.clangFile));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 0 || string2.charAt(0) != '(') continue;
                this.C.send(string2);
                System.out.println("Sending: " + string2);
            }
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            System.err.println("Unable to send CLang: " + exception);
            System.exit(1);
        }
        this.C.disconnect();
        System.out.println("Shutting down coach.");
    }

    public static void main(String[] stringArray) {
        String string = "localhost";
        int n = 6002;
        String string2 = "Coachable";
        String string3 = "";
        try {
            for (int i = 0; i < stringArray.length; i += 2) {
                if (stringArray[i].equals("-host")) {
                    string = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equals("-port")) {
                    n = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-team")) {
                    string2 = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equals("-clang")) {
                    string3 = stringArray[i + 1];
                    continue;
                }
                System.err.println("Unknown option: " + stringArray[i]);
            }
        }
        catch (Exception exception) {
            System.err.println("Unable to parse commandline options: " + exception);
            System.exit(1);
        }
        Connection connection = new Connection(string, n);
        CLangSender cLangSender = new CLangSender(connection, string2, string3);
        cLangSender.mainLoop();
    }
}

