/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.coach;

import java.util.ArrayList;
import java.util.LinkedList;
import rcssjava.ServerParams;
import rcssjava.Utils;
import rcssjava.VecPosition;
import rcssjava.WorldState;
import rcssjava.coach.FeaturesStorage;
import rcssjava.coach.FormFix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureCollector {
    static final boolean debug = false;
    WorldState ws;
    ServerParams SP;
    FormFix f;
    private int lastPossessorID;
    private int beforeLastPossessorID;
    private int prevNumPlayersByBall;
    private int BOwner;
    private int prevCycleBOwner;
    private int secPrevCycleBOwner;
    private boolean baseRunning = false;
    private boolean patternRunning = false;
    private VecPosition prevBallVel;
    private VecPosition prevBallPos;
    private VecPosition currBallVel;
    private VecPosition currBallPos;
    private VecPosition prevBOwnerVel;
    private VecPosition prevBOwnerPos;
    private VecPosition currBOwnerVel;
    private VecPosition currBOwnerPos;
    private VecPosition secPrevBOwnerVel;
    private VecPosition secPrevBOwnerPos;
    private int possessionCycles;
    private static int sideBeingModeled;
    private static int sideBeingControlled;
    private LinkedList<FeaturesStorage> currFeatStorList;
    private int[] playerIDsByNum = new int[22];
    private int[] playerNumsByID = new int[22];
    private FeaturesStorage features;

    public FeatureCollector(int n, ServerParams serverParams) {
        if (n != 0 && n != 1) {
            System.err.println("sideBeingModeled error: not 0 or 1");
            System.exit(1);
        }
        sideBeingControlled = (sideBeingModeled = n) == 0 ? 1 : 0;
        this.setPlayerIDsByNum();
        this.SP = serverParams;
        this.f = new FormFix(sideBeingModeled);
    }

    private void debugln(String string) {
    }

    public void processCycle(WorldState worldState, LinkedList<FeaturesStorage> linkedList) {
        this.currFeatStorList = linkedList;
        this.ws = worldState;
        if (this.ws.getPlayMode() == 3) {
            this.playOnPByP();
            this.recordFormation();
        } else if (this.ws.getPlayMode() == 14) {
            this.processGoal(0);
        } else if (this.ws.getPlayMode() == 15) {
            this.processGoal(1);
        }
    }

    private void setPlayerIDsByNum() {
        if (sideBeingModeled == 0) {
            for (int i = 0; i < 22; ++i) {
                this.playerIDsByNum[i] = i;
                this.playerNumsByID[i] = i;
            }
        } else {
            int n;
            for (n = 0; n < 11; ++n) {
                this.playerIDsByNum[n] = n + 11;
                this.playerNumsByID[n + 11] = n;
            }
            for (n = 11; n < 22; ++n) {
                this.playerIDsByNum[n] = n - 11;
                this.playerNumsByID[n - 11] = n;
            }
        }
    }

    private void playOnPByP() {
        int n;
        this.prevBallVel = this.currBallVel;
        this.prevBallPos = this.currBallPos;
        this.currBallVel = this.f.fix(this.ws.getBallVelocity());
        this.currBallPos = this.f.fix(this.ws.getBallPosition());
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < 22; ++n) {
            if (!this.ws.isBallKickableBy(n)) continue;
            arrayList.add(n);
        }
        this.secPrevBOwnerVel = this.prevBOwnerVel;
        this.secPrevBOwnerPos = this.prevBOwnerPos;
        this.prevBOwnerVel = this.currBOwnerVel;
        this.prevBOwnerPos = this.currBOwnerPos;
        n = arrayList.size() == 1 ? 1 : 0;
        this.secPrevCycleBOwner = this.prevCycleBOwner;
        this.prevCycleBOwner = this.BOwner;
        this.BOwner = -1;
        if (n != 0) {
            this.BOwner = (Integer)arrayList.get(0);
        }
        this.currBOwnerVel = n != 0 ? this.f.fix(this.ws.getPlayerVelocity(this.BOwner)) : null;
        VecPosition vecPosition = this.currBOwnerPos = n != 0 ? this.f.fix(this.ws.getPlayerPosition(this.BOwner)) : null;
        if (arrayList.size() == 0) {
            if (this.prevNumPlayersByBall > 0 && this.lastPossessorID != -1) {
                this.debugln("Ball kicked by Player " + this.lastPossessorID + " of " + this.ws.getTeamNameFromPlayer(this.lastPossessorID) + " at Cycle " + (this.ws.getTime() - 1));
                if (this.prevNumPlayersByBall == 1) {
                    this.processKick();
                }
            } else if (this.prevNumPlayersByBall > 0 && this.lastPossessorID == -1) {
                this.debugln("Ball kicked out of Player cluster by unknown Player");
            }
        } else if (arrayList.size() == 1) {
            int n2 = (Integer)arrayList.get(0);
            if (this.lastPossessorID != n2 && this.lastPossessorID != -1) {
                if (Utils.getSideFromID(n2) != Utils.getSideFromID(this.lastPossessorID)) {
                    this.debugln("Possession taken by Player " + n2 + " of " + this.ws.getTeamNameFromPlayer(n2) + " at Cycle " + this.ws.getTime());
                } else {
                    this.debugln("Pass from Player " + this.lastPossessorID + " received by Player " + n2 + " of " + this.ws.getTeamNameFromPlayer(n2) + " at Cycle " + this.ws.getTime());
                }
                if (this.lastPossessorID != n2) {
                    this.processPass(this.lastPossessorID, n2);
                }
                this.beforeLastPossessorID = this.lastPossessorID;
                this.lastPossessorID = n2;
            } else if (this.lastPossessorID == -1) {
                if (this.prevNumPlayersByBall == 0) {
                    this.debugln("Kick from unknown Player received by Player " + n2);
                    this.beforeLastPossessorID = this.lastPossessorID;
                    this.lastPossessorID = n2;
                } else if (this.prevNumPlayersByBall > 1) {
                    this.debugln("Ball taken from Player cluster by Player" + n2 + " of " + this.ws.getTeamNameFromPlayer(n2) + " at Cycle " + this.ws.getTime());
                    this.beforeLastPossessorID = this.lastPossessorID;
                    this.lastPossessorID = n2;
                }
            }
        } else if (arrayList.size() >= 2 && this.prevNumPlayersByBall == 1) {
            this.debugln("Possession in contention between Players ");
            for (Integer n3 : arrayList) {
                this.debugln(n3 + " of " + this.ws.getTeamNameFromPlayer(n3) + " | ");
            }
            this.debugln("");
            this.beforeLastPossessorID = this.lastPossessorID;
            this.lastPossessorID = -1;
        }
        this.prevNumPlayersByBall = arrayList.size();
    }

    private void processGoal(int n) {
        this.debugln(this.ws.getTime() + ": " + this.ws.getTeamName(n) + " scores!");
    }

    private void processPass(int n, int n2) {
        if (this.playerNumsByID[n] <= 10) {
            for (int i = 0; i < this.currFeatStorList.size(); ++i) {
                this.currFeatStorList.get(i).countPass(this.playerNumsByID[n], this.playerNumsByID[n2]);
            }
        }
    }

    private void processKick() {
        if (this.f.fix(this.ws.getBallVelocity()).getMagnitude() > 1.0 && this.playerNumsByID[this.lastPossessorID] <= 10) {
            int[] nArray = this.whichTargets(true);
            for (int i = 0; i < this.currFeatStorList.size(); ++i) {
                FeaturesStorage featuresStorage = this.currFeatStorList.get(i);
                int n = 0;
                while (nArray[n] != -1) {
                    featuresStorage.countKickDir(this.playerNumsByID[this.lastPossessorID], nArray[n]);
                    ++n;
                }
                int n2 = this.playerNumsByID[this.lastPossessorID];
                featuresStorage.totalKickCount[n2] = featuresStorage.totalKickCount[n2] + 1;
            }
        }
    }

    private int[] whichTargets(boolean bl) {
        int n = 0;
        int[] nArray = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        double d = this.yAtX(0.0, bl);
        if (d < 2.5 && d > -2.5) {
            nArray[n] = 0;
            ++n;
        } else if (d < -31.5 && d > -36.5) {
            nArray[n] = 1;
            ++n;
        } else if (d < 36.5 && d > 31.5) {
            nArray[n] = 2;
            ++n;
        }
        d = this.yAtX(-52.5, bl);
        if (d < -31.5 && d > -36.5) {
            nArray[n] = 3;
            ++n;
        } else if (d < 36.5 && d > 31.5) {
            nArray[n] = 4;
            ++n;
        } else if (d < 9.5 && d > -9.5) {
            nArray[n] = 15;
            ++n;
        } else if (d < this.currBallPos.getY() + 1.0 && d > this.currBallPos.getY() - 1.0) {
            nArray[n] = 10;
            ++n;
        }
        d = this.yAtX(52.5, bl);
        if (d < -31.5 && d > -36.5) {
            nArray[n] = 5;
            ++n;
        } else if (d < 36.5 && d > 31.5) {
            nArray[n] = 6;
            ++n;
        } else if (d < 9.5 && d > -9.5) {
            nArray[n] = 16;
            ++n;
        } else if (d < this.currBallPos.getY() + 2.5 && d > this.currBallPos.getY() - 2.5) {
            nArray[n] = 9;
            ++n;
        }
        double d2 = this.xAtY(-34.0, bl);
        if (d2 < this.currBallPos.getX() + 2.5 && d2 > this.currBallPos.getX() - 2.5) {
            nArray[n] = 7;
            ++n;
        }
        if ((d2 = this.xAtY(34.0, bl)) < this.currBallPos.getX() + 2.5 && d2 > this.currBallPos.getX() - 2.5) {
            nArray[n] = 8;
            ++n;
        }
        return nArray;
    }

    private double yAtX(double d, boolean bl) {
        if (bl) {
            return this.ballYPosAtX(d);
        }
        return this.dribbleYPosAtX(d);
    }

    private double xAtY(double d, boolean bl) {
        if (bl) {
            return this.ballXPosAtY(d);
        }
        return this.dribbleXPosAtY(d);
    }

    private double dribbleYPosAtX(double d) {
        double d2 = (this.secPrevBOwnerPos.getY() - this.currBOwnerPos.getY()) / this.secPrevBOwnerPos.getX() - this.currBOwnerPos.getX();
        double d3 = d2 * (d - this.currBOwnerPos.getX()) + this.currBOwnerPos.getY();
        return d3;
    }

    private double dribbleXPosAtY(double d) {
        double d2 = (this.secPrevBOwnerPos.getY() - this.currBOwnerPos.getY()) / this.secPrevBOwnerPos.getX() - this.currBOwnerPos.getX();
        double d3 = 1.0 / d2 * (d - this.currBOwnerPos.getY()) + this.currBOwnerPos.getX();
        return d3;
    }

    private double ballYPosAtX(double d) {
        double d2 = this.currBallVel.getY() / this.currBallVel.getX() * (d - this.currBallPos.getX()) + this.currBallPos.getY();
        return d2;
    }

    private double ballXPosAtY(double d) {
        double d2 = this.currBallVel.getX() / this.currBallVel.getY() * (d - this.currBallPos.getY()) + this.currBallPos.getX();
        return d2;
    }

    private void recordFormation() {
        int n;
        VecPosition vecPosition = this.f.fix(this.ws.getBallPosition());
        VecPosition[] vecPositionArray = new VecPosition[11];
        for (n = 0; n < 11; ++n) {
            vecPositionArray[n] = this.f.fix(this.ws.getPlayerPosition(this.playerIDsByNum[n]));
        }
        n = this.fastestToBallNum();
        for (int i = 0; i < this.currFeatStorList.size(); ++i) {
            FeaturesStorage featuresStorage = this.currFeatStorList.get(i);
            for (int j = 0; j < 11; ++j) {
                if (n != j) {
                    featuresStorage.writeFormation(j, vecPosition, vecPositionArray[j]);
                    featuresStorage.ballPositions.get(j).add(vecPosition);
                    continue;
                }
                if (n != j) continue;
            }
        }
    }

    private int fastestToBallNum() {
        boolean bl = false;
        int n = -1;
        if (this.BOwner != -1 && this.playerNumsByID[this.BOwner] <= 10) {
            bl = true;
            n = this.playerNumsByID[this.BOwner];
        }
        int n2 = 0;
        VecPosition vecPosition = this.currBallPos;
        VecPosition vecPosition2 = this.currBallVel;
        while (!bl) {
            double d = -1.0;
            for (int i = 0; i <= 10; ++i) {
                int n3 = this.playerIDsByNum[i];
                VecPosition vecPosition3 = this.f.fix(this.ws.getPlayerPosition(n3));
                double d2 = (double)n2 * this.SP.player_speed_max - vecPosition3.getDistanceTo(vecPosition);
                if (!(d2 >= 0.0) || !(d2 > d)) continue;
                d = d2;
                bl = true;
                n = i;
            }
            vecPosition = vecPosition.add(vecPosition2);
            vecPosition2 = vecPosition2.multiply(this.SP.ball_decay);
            ++n2;
        }
        return n;
    }
}

