/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.coach;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import rcssjava.VecPosition;
import rcssjava.coach.InsufficientDataException;
import rcssjava.geom.Line;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearRegression
implements Serializable {
    int m_numPoints;
    double m_sumX;
    double m_sumY;
    double m_sumXX;
    double m_sumXY;
    double m_sumYY;

    public LinearRegression() {
        this.reset();
    }

    public void reset() {
        this.m_numPoints = 0;
        this.m_sumX = 0.0;
        this.m_sumY = 0.0;
        this.m_sumXX = 0.0;
        this.m_sumXY = 0.0;
        this.m_sumYY = 0.0;
    }

    public void addPoint(VecPosition vecPosition) {
        ++this.m_numPoints;
        this.m_sumX += vecPosition.getX();
        this.m_sumY += vecPosition.getY();
        this.m_sumXX += vecPosition.getX() * vecPosition.getX();
        this.m_sumXY += vecPosition.getX() * vecPosition.getY();
        this.m_sumYY += vecPosition.getY() * vecPosition.getY();
    }

    public int getNumPoints() {
        return this.m_numPoints;
    }

    public Line getBestFitLine() throws InsufficientDataException {
        if (this.m_numPoints < 2) {
            throw new InsufficientDataException("getBestFitLine: need at least two points to make line");
        }
        double d = this.m_sumXX - this.m_sumX * this.m_sumX / (double)this.m_numPoints;
        double d2 = this.m_sumXY - this.m_sumX * this.m_sumY / (double)this.m_numPoints;
        if (Math.abs(d) <= 1.0E-5) {
            return new Line(0.0, 1.0, -this.m_sumX / (double)this.m_numPoints);
        }
        double d3 = d2 / d;
        return new Line(1.0, -d3, (d3 * this.m_sumX - this.m_sumY) / (double)this.m_numPoints);
    }

    public double getRMSError() throws InsufficientDataException {
        if (this.m_numPoints < 3) {
            throw new InsufficientDataException("getMeanSquaredError: need at least three points to compute error");
        }
        double d = this.m_sumXX - this.m_sumX * this.m_sumX / (double)this.m_numPoints;
        double d2 = this.m_sumXY - this.m_sumX * this.m_sumY / (double)this.m_numPoints;
        double d3 = this.m_sumYY - this.m_sumY * this.m_sumY / (double)this.m_numPoints;
        double d4 = d3 - d2 * d2 / d;
        return Math.sqrt(d4 / (double)(this.m_numPoints - 2));
    }

    public double getRMSError(Collection<VecPosition> collection) throws InsufficientDataException {
        if (collection == null || collection.size() < 3) {
            throw new InsufficientDataException("getMeanSquaredError: need at least three points to compute error");
        }
        Line line = this.getBestFitLine();
        if (line.getA() == 0.0) {
            return Double.MAX_VALUE;
        }
        double d = 0.0;
        for (VecPosition vecPosition : collection) {
            d += Math.pow(vecPosition.getY() - line.getYGivenX(vecPosition.getX()), 2.0);
        }
        return Math.sqrt(d / (double)(collection.size() - 2));
    }

    public static void main(String[] stringArray) throws Exception {
        LinearRegression linearRegression = new LinearRegression();
        ArrayList<VecPosition> arrayList = new ArrayList<VecPosition>();
        arrayList.add(new VecPosition(0.0, 1.0));
        arrayList.add(new VecPosition(1.0, 2.1));
        arrayList.add(new VecPosition(3.0, 3.9));
        arrayList.add(new VecPosition(2.0, 3.0));
        for (VecPosition vecPosition : arrayList) {
            linearRegression.addPoint(vecPosition);
        }
        Line line = linearRegression.getBestFitLine();
        System.out.println("m: " + line.getSlope());
        System.out.println("b: " + line.getYIntercept());
        System.out.println("error1: " + linearRegression.getRMSError());
        System.out.println("error2: " + linearRegression.getRMSError(arrayList));
    }
}

