/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.coach;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import rcssjava.ServerParams;
import rcssjava.VecPosition;
import rcssjava.WorldState;
import rcssjava.coach.ConditionsStorage;
import rcssjava.coach.FeatureCollector;
import rcssjava.coach.FeaturesStorage;
import rcssjava.coach.FormFix;
import rcssjava.coach.InsufficientDataException;
import rcssjava.coach.Pattern;
import rcssjava.coach.WeightStorage;
import rcssjava.gamelog.GameLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternAnalyzer {
    ServerParams SP;
    FeatureCollector baseCollector;
    FeatureCollector patternCollector;
    private boolean baseRunning = false;
    private boolean patternRunning = false;
    public static int sideBeingModeled;
    private static int sideBeingControlled;
    private LinkedList<FeaturesStorage> currFeatStorList;
    private ConditionsStorage baseConditions = new ConditionsStorage();
    private ConditionsStorage patternConditions = new ConditionsStorage();
    private WeightStorage trueWeights = new WeightStorage();
    FormFix f;
    private Pattern pattern = new Pattern();
    private Vector<WorldState> baseStates;
    private Vector<WorldState> patternStates;
    private static String patternFilePrefix;
    int analyzeAttempts;

    public PatternAnalyzer(String string, String string2, String string3, int n) {
        this.SP = new ServerParams();
        this.baseStates = this.parseGameLog(string);
        this.patternStates = this.parseGameLog(string2);
        patternFilePrefix = string3;
        this.analyzeAttempts = n;
    }

    private Vector<WorldState> parseGameLog(String string) {
        Vector<WorldState> vector = new Vector<WorldState>();
        System.out.print("Parsing game log: " + string);
        GameLog gameLog = new GameLog(string);
        int n = -1;
        WorldState worldState = new WorldState(this.SP);
        gameLog.setWorldState(worldState);
        while (worldState.getPlayMode() != 2 && gameLog.readNext()) {
            if (worldState.getTime() <= n) continue;
            vector.add(worldState);
            worldState = new WorldState(this.SP).copy(worldState);
            gameLog.setWorldState(worldState);
            if (worldState.getTime() % 200 == 0) {
                System.out.print(".");
            }
            n = worldState.getTime();
        }
        System.out.println("...done");
        return vector;
    }

    private void playByPlay(Vector<WorldState> vector) {
        block8: {
            try {
                sideBeingModeled = vector.get(100).getSideFromTeamName("Coachable");
                if (sideBeingModeled == -1) {
                    sideBeingModeled = vector.get(100).getSideFromTeamName("Pattern");
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("!!!!!PatternAnalyzer attempt " + (this.analyzeAttempts + 1) + " failed!!!!!");
                if (this.analyzeAttempts >= 2) break block8;
                System.out.println("Trying again.");
                String object = patternFilePrefix + "-nopattern.rcg";
                String string = patternFilePrefix + ".rcg";
                PatternAnalyzer patternAnalyzer = new PatternAnalyzer(object, string, patternFilePrefix, this.analyzeAttempts + 1);
            }
        }
        System.out.println("\nsideBeingModeled: " + sideBeingModeled);
        System.out.println("Side 0 TeamName: " + vector.get(5).getTeamName(0));
        System.out.println("Side 1 TeamName: " + vector.get(5).getTeamName(1) + "\n");
        this.f = new FormFix(sideBeingModeled);
        if (this.baseRunning) {
            this.baseCollector = new FeatureCollector(sideBeingModeled, this.SP);
        } else {
            this.patternCollector = new FeatureCollector(sideBeingModeled, this.SP);
        }
        for (WorldState worldState : vector) {
            this.currFeatStorList = this.featuresStorageLinkedList(worldState);
            if (worldState.getTime() % 100 == 0) {
                // empty if block
            }
            if (this.baseRunning) {
                this.baseCollector.processCycle(worldState, this.currFeatStorList);
                continue;
            }
            this.patternCollector.processCycle(worldState, this.currFeatStorList);
        }
    }

    private LinkedList<FeaturesStorage> featuresStorageLinkedList(WorldState worldState) {
        ConditionsStorage conditionsStorage = this.baseRunning ? this.baseConditions : this.patternConditions;
        LinkedList<FeaturesStorage> linkedList = new LinkedList<FeaturesStorage>();
        linkedList.add(conditionsStorage.trueFeatures);
        return linkedList;
    }

    private void printFinalFeatures() {
        int n;
        int n2;
        FeaturesStorage featuresStorage = this.baseConditions.trueFeatures;
        System.out.println("passMatrix");
        for (n2 = 0; n2 < 11; ++n2) {
            System.out.println("");
            for (n = 0; n < 22; ++n) {
                System.out.print(featuresStorage.passMatrix[n2][n] + " ");
            }
        }
        System.out.println("\n\n");
        System.out.println("kickDirCount");
        for (n2 = 0; n2 < 11; ++n2) {
            System.out.println("");
            for (n = 0; n < 15; ++n) {
                System.out.print(featuresStorage.kickDirCount[n2][n] + " ");
            }
            System.out.print(" -- " + featuresStorage.totalKickCount[n2]);
        }
        System.out.println("\n\n");
        System.out.println("formation\n");
        for (n2 = 0; n2 < 11; ++n2) {
            System.out.println("HP Player: " + n2 + ":  " + featuresStorage.formation[n2].getHomePosition().toString());
            System.out.println("BA Player " + n2 + ":  " + featuresStorage.formation[n2].getBallAttraction().toString());
        }
    }

    private void getFinalFeatsAndWeights() {
        ConditionsStorage conditionsStorage = this.baseConditions;
        ConditionsStorage conditionsStorage2 = this.patternConditions;
        this.getFormationWeights(conditionsStorage.trueFeatures, conditionsStorage2.trueFeatures, this.trueWeights);
        conditionsStorage.trueFeatures.calcPassPerc();
        conditionsStorage2.trueFeatures.calcPassPerc();
        conditionsStorage.trueFeatures.calcKickDPerc();
        conditionsStorage2.trueFeatures.calcKickDPerc();
        this.trueWeights.getPassWeights(conditionsStorage.trueFeatures, conditionsStorage2.trueFeatures);
        this.trueWeights.getKickWeights(conditionsStorage.trueFeatures, conditionsStorage2.trueFeatures);
    }

    private void getFormationWeights(FeaturesStorage featuresStorage, FeaturesStorage featuresStorage2, WeightStorage weightStorage) {
        for (int i = 0; i <= 10; ++i) {
            double d;
            double d2 = 0.0;
            double d3 = 0.0;
            try {
                d = featuresStorage.formation[i].getError();
                double d4 = featuresStorage2.formation[i].getError();
                double d5 = featuresStorage.formation[i].getError((List<VecPosition>)featuresStorage2.ballPositions.get(i), featuresStorage2.formation[i].playerPositionsList);
                double d6 = featuresStorage2.formation[i].getError((List<VecPosition>)featuresStorage.ballPositions.get(i), featuresStorage.formation[i].playerPositionsList);
                d2 = (d5 + d6) / (d + d4);
                d3 = d2 - 1.0;
            }
            catch (InsufficientDataException insufficientDataException) {
                d2 = 0.0;
                d3 = 0.0;
            }
            weightStorage.formationError[i] = d = 1.0 - Math.pow(Math.E, -d3);
        }
    }

    private void putFeatAndWeightsInPattern() {
        this.pattern.baseFeatStorArray.add(this.baseConditions.trueFeatures);
        this.pattern.patternFeatStorArray.add(this.patternConditions.trueFeatures);
        this.pattern.weightStorArray.add(this.trueWeights);
        this.pattern.getPattTotWts();
        this.pattern.patternName = patternFilePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePatternToFile() {
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(patternFilePrefix + ".ser");
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.pattern);
            System.out.println("Pattern serialized into " + patternFilePrefix + ".ser");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                objectOutputStream.flush();
                objectOutputStream.close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void mainLoop() {
        System.out.println("\n");
        System.out.println("Collecting data for " + patternFilePrefix + "-nopattern.rcg");
        this.baseRunning = true;
        this.playByPlay(this.baseStates);
        this.baseRunning = false;
        System.out.println("Base Strategy finished\n");
        System.out.println("Collecting data for " + patternFilePrefix + ".rcg");
        this.patternRunning = true;
        this.playByPlay(this.patternStates);
        this.patternRunning = false;
        System.out.println("Pattern finished\n");
        this.getFinalFeatsAndWeights();
        this.putFeatAndWeightsInPattern();
        this.writePatternToFile();
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            string3 = stringArray[0];
            string = stringArray[1];
            string2 = stringArray[2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Usage: java PatternAnalyzer <patternName> <base.rcg> <pattern.rcg> ");
            System.exit(1);
        }
        System.out.println("\n");
        PatternAnalyzer patternAnalyzer = new PatternAnalyzer(string, string2, string3, 0);
        patternAnalyzer.mainLoop();
    }

    static {
        patternFilePrefix = null;
    }
}

