/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.comm;

import rcssjava.SoccerTypes;
import rcssjava.Utils;
import rcssjava.VecPosition;
import rcssjava.WorldState;
import rcssjava.comm.CoachCommandHandler;
import rcssjava.comm.Connection;

public class TrainerCommandHandler
extends CoachCommandHandler {
    public TrainerCommandHandler(Connection connection) {
        super(connection);
    }

    public TrainerCommandHandler(Connection connection, WorldState worldState) {
        super(connection, worldState);
    }

    private String getObjectStringFromID(int n) {
        if (Utils.isBall(n)) {
            return "(ball)";
        }
        if (Utils.isPlayer(n)) {
            String string = this.WS.getTeamName(Utils.getSideFromID(n));
            int n2 = Utils.getUnumFromID(n);
            return "(player " + string + " " + n2 + ")";
        }
        System.err.println("getObjectStringFromID: Object " + n + " is not a ball or player");
        return null;
    }

    public void changeMode(int n) {
        String string = "(change_mode " + SoccerTypes.PLAYMODE_STRINGS[n] + ")";
        this.C.send(string);
    }

    public void move(int n, VecPosition vecPosition) {
        this.move(n, vecPosition, null);
    }

    public void move(int n, VecPosition vecPosition, VecPosition vecPosition2) {
        this.move(n, vecPosition, 0.0, vecPosition2);
    }

    public void move(int n, VecPosition vecPosition, double d) {
        this.move(n, vecPosition, d, new VecPosition());
    }

    public void move(int n, VecPosition vecPosition, double d, VecPosition vecPosition2) {
        String string = "(move " + this.getObjectStringFromID(n) + " " + vecPosition.getX() + " " + vecPosition.getY();
        if (vecPosition2 != null) {
            string = string + " " + d + " " + vecPosition2.getX() + " " + vecPosition2.getY();
        }
        string = string + ")";
        this.C.send(string);
    }

    public void checkBall() {
        String string = "(check_ball)";
        this.C.send(string);
    }

    public void start() {
        String string = "(start)";
        this.C.send(string);
    }

    public void recover() {
        String string = "(recover)";
        this.C.send(string);
    }

    public void ear(boolean bl) {
        String string = "(ear " + (bl ? "on" : "off") + ")";
        this.C.send(string);
    }

    public void init(double d) {
        this.init("", d);
    }

    public void changePlayerType(int n, int n2) {
        String string = this.WS.getTeamName(Utils.getSideFromID(n));
        int n3 = Utils.getUnumFromID(n);
        String string2 = "(change_player_type " + string + " " + n3 + " " + n2 + ")";
        this.C.send(string2);
    }
}

