/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.geom;

import rcssjava.VecPosition;
import rcssjava.geom.Line;
import rcssjava.geom.Rectangle;

public class LineSegment {
    private VecPosition p1;
    private VecPosition p2;

    public LineSegment() {
        this.p1 = new VecPosition();
        this.p2 = new VecPosition();
    }

    public LineSegment(VecPosition vecPosition, VecPosition vecPosition2) {
        this.setPoints(vecPosition, vecPosition2);
    }

    public void setPoints(VecPosition vecPosition, VecPosition vecPosition2) {
        this.p1 = vecPosition;
        this.p2 = vecPosition2;
    }

    public double getLength() {
        return this.p1.getDistanceTo(this.p2);
    }

    public VecPosition getMidpoint() {
        return this.p1.add(this.p2).divide(2.0);
    }

    public Rectangle getBoundingRectangle() {
        return new Rectangle(this.p1, this.p2);
    }

    public Line getLine() {
        return Line.makeLineFromTwoPoints(this.p1, this.p2);
    }

    public VecPosition getIntersection(Line line) {
        Line line2 = this.getLine();
        if (line2 == null) {
            return null;
        }
        VecPosition vecPosition = line2.getIntersection(line);
        if (vecPosition == null || !this.getBoundingRectangle().isInside(vecPosition)) {
            return null;
        }
        return vecPosition;
    }

    public VecPosition getIntersection(LineSegment lineSegment) {
        Line line = lineSegment.getLine();
        if (line == null) {
            return null;
        }
        VecPosition vecPosition = this.getIntersection(line);
        if (vecPosition == null || !lineSegment.getBoundingRectangle().isInside(vecPosition)) {
            return null;
        }
        return vecPosition;
    }
}

