/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.geom;

import java.util.Iterator;
import java.util.Vector;
import rcssjava.VecPosition;
import rcssjava.geom.LineSegment;
import rcssjava.geom.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rectangle
implements Region {
    private VecPosition topLeft;
    private VecPosition bottomRight;

    public Rectangle() {
        this.topLeft = new VecPosition();
        this.bottomRight = new VecPosition();
    }

    public Rectangle(double d, double d2) {
        this(d, d2, new VecPosition(0.0, 0.0));
    }

    public Rectangle(double d, double d2, VecPosition vecPosition) {
        this(vecPosition.subtract(new VecPosition(d2 / 2.0, d / 2.0)), vecPosition.add(new VecPosition(d2 / 2.0, d / 2.0)));
    }

    public Rectangle(VecPosition vecPosition, VecPosition vecPosition2) {
        this.setPoints(vecPosition, vecPosition2);
    }

    public void setPoints(VecPosition vecPosition, VecPosition vecPosition2) {
        double d = vecPosition.isInFrontOf(vecPosition2) ? vecPosition.getX() : vecPosition2.getX();
        double d2 = vecPosition.isBehind(vecPosition2) ? vecPosition.getX() : vecPosition2.getX();
        double d3 = vecPosition.isLeftOf(vecPosition2) ? vecPosition.getY() : vecPosition2.getY();
        double d4 = vecPosition.isRightOf(vecPosition2) ? vecPosition.getY() : vecPosition2.getY();
        this.topLeft = new VecPosition(d, d3);
        this.bottomRight = new VecPosition(d2, d4);
    }

    public VecPosition getTopLeft() {
        return this.topLeft;
    }

    public VecPosition getBottomRight() {
        return this.bottomRight;
    }

    public VecPosition getTopRight() {
        return new VecPosition(this.getTopX(), this.getRightY());
    }

    public VecPosition getBottomLeft() {
        return new VecPosition(this.getBottomX(), this.getLeftY());
    }

    public double getTopX() {
        return this.topLeft.getX();
    }

    public double getBottomX() {
        return this.bottomRight.getX();
    }

    public double getLeftY() {
        return this.topLeft.getY();
    }

    public double getRightY() {
        return this.bottomRight.getY();
    }

    public LineSegment getTopSide() {
        return new LineSegment(this.getTopLeft(), this.getTopRight());
    }

    public LineSegment getBottomSide() {
        return new LineSegment(this.getBottomLeft(), this.getBottomRight());
    }

    public LineSegment getLeftSide() {
        return new LineSegment(this.getTopLeft(), this.getBottomLeft());
    }

    public LineSegment getRightSide() {
        return new LineSegment(this.getBottomRight(), this.getTopRight());
    }

    public Iterator<VecPosition> cornerIterator() {
        Vector<VecPosition> vector = new Vector<VecPosition>();
        vector.add(this.getTopLeft());
        vector.add(this.getTopRight());
        vector.add(this.getBottomRight());
        vector.add(this.getBottomLeft());
        return vector.iterator();
    }

    public Iterator<LineSegment> sideIterator() {
        Vector<LineSegment> vector = new Vector<LineSegment>();
        vector.add(this.getTopSide());
        vector.add(this.getRightSide());
        vector.add(this.getBottomSide());
        vector.add(this.getLeftSide());
        return vector.iterator();
    }

    @Override
    public boolean isInside(VecPosition vecPosition) {
        return vecPosition.isBetweenX(this.bottomRight, this.topLeft) && vecPosition.isBetweenY(this.topLeft, this.bottomRight);
    }

    public VecPosition getCenter() {
        return this.bottomRight.add(this.topLeft).divide(2.0);
    }

    public double getWidth() {
        return this.bottomRight.subtract(this.topLeft).getY();
    }

    public double getLength() {
        return this.topLeft.subtract(this.bottomRight).getX();
    }

    public Rectangle add(double d) {
        return this.add(new VecPosition(d, d));
    }

    public Rectangle add(VecPosition vecPosition) {
        return new Rectangle(this.getWidth(), this.getLength(), this.getCenter().add(vecPosition));
    }

    public Rectangle subtract(double d) {
        return this.subtract(new VecPosition(d, d));
    }

    public Rectangle subtract(VecPosition vecPosition) {
        return new Rectangle(this.getWidth(), this.getLength(), this.getCenter().subtract(vecPosition));
    }

    public String toString() {
        return "[" + this.topLeft + ", " + this.bottomRight + "]";
    }
}

