#!/bin/sh
#
# Analyze pattern logfiles
#
# This script is used to start your offline analyzer up.
#
# All teams are expected to put their startup script in
#  their home directory. We will run your offline analyzer
#  through a script with the same name as this script (i.e.
#  offline-analyzer.sh).
#
# This is just a sample script to demonstrate what is needed
#  for running your offline analyzer. Of course you are free
#  to modify or change it in a way you like.
#
# The patterns' logs are placed in a directory which is passed
#  to this script as an argument (pattern_dir in this script).
#
# The name of the patterns which are used in this round is
#  stored in "patterns.list" inside that directory. So for each
#  pattern name in this list, there exists two .rcg log files,
#  one for the pattern itself named "pattern_name.rcg", and the
#  second one for the corresponding no-pattern file named
#  "pattern_name-nopattern.rcg".
#
# The given sample list shows that there exists 3 patterns named
#  "pattern01", "pattern02", and "pattern03". For each of these
#  patterns there exists two log files which are named:
#  for pattern01: "pattern01.rcg", "pattern01-nopattern.rcg"
#  for pattern02: "pattern02.rcg", "pattern02-nopattern.rcg"
#  for pattern03: "pattern03.rcg", "pattern03-nopattern.rcg"
#
# Therefore, the only input to this script is the the absolute
#  path to the patterns directory. So the usage is:
#
# Usage: ./offline-analyzer.sh /path/to/logs

# DO NOT MODIFY

pattern_dir=$1
num_patterns=`cat $pattern_dir/patterns.list | wc -l`

# MODIFY

# Put code here to initialize the coach for a new round
# Maybe tell it to expect $num_patterns patterns

# Go through each pattern
for pattern_name in `cat $pattern_dir/patterns.list`; do
  # RCG for the no-pattern
  rcg_no_pattern=$pattern_dir/$pattern_name-nopattern.rcg
  # RCG for pattern itself
  rcg_pattern=$pattern_dir/$pattern_name.rcg

  # Process pattern logs here
  java -cp rcssjava.jar rcssjava.coach.NormalizeM $pattern_name $pattern_dir
done
