/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.logging.Logger;
import se.sics.tasim.props.BOMBundle;
import se.sics.tasim.props.ComponentCatalog;
import se.sics.tasim.props.InventoryStatus;
import se.sics.tasim.props.OfferBundle;
import se.sics.tasim.props.RFQBundle;
import se.sics.tasim.props.SimulationStatus;
import se.sics.tasim.props.StartInfo;
import se.sics.tasim.tac03.aw.Order;
import se.sics.tasim.tac03.aw.OrderStore;
import se.sics.tasim.tac03.aw.SCMAgent;

public class ExampleAgent
extends SCMAgent {
    private static final Logger log = Logger.getLogger(ExampleAgent.class.getName());
    private Random random = new Random();
    private int lastBidDueDate;
    private double priceDiscountFactor = 0.2;
    private InventoryStatus componentDemand = new InventoryStatus();

    protected void simulationStarted() {
        StartInfo startInfo = this.getStartInfo();
        this.lastBidDueDate = startInfo.getNumberOfDays() - 2;
    }

    protected void simulationEnded() {
    }

    protected void handleCustomerRFQs(RFQBundle rFQBundle) {
        int n = this.getCurrentDate();
        int n2 = rFQBundle.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = rFQBundle.getDueDate(i);
            if (n3 - n < 6 || n3 > this.lastBidDueDate) continue;
            int n4 = rFQBundle.getReservePricePerUnit(i);
            int n5 = (int)((double)n4 * (1.0 - this.random.nextDouble() * this.priceDiscountFactor));
            this.addCustomerOffer(rFQBundle, i, n5);
        }
        this.sendCustomerOffers();
    }

    protected void handleCustomerOrders(Order[] orderArray) {
        int n;
        int n2;
        int n3;
        BOMBundle bOMBundle = this.getBOMBundle();
        for (Order order : orderArray) {
            n3 = order.getProductID();
            n2 = order.getQuantity();
            int[] nArray = bOMBundle.getComponentsForProductID(n3);
            if (nArray == null) continue;
            n = nArray.length;
            for (int i = 0; i < n; ++i) {
                this.componentDemand.addInventory(nArray[i], n2);
            }
        }
        ComponentCatalog componentCatalog = this.getComponentCatalog();
        int n4 = this.getCurrentDate();
        n3 = this.componentDemand.getProductCount();
        for (int i = 0; i < n3; ++i) {
            n2 = this.componentDemand.getQuantity(i);
            if (n2 <= 0) continue;
            int n5 = this.componentDemand.getProductID(i);
            String[] stringArray = componentCatalog.getSuppliersForProduct(n5);
            if (stringArray != null) {
                n = this.random.nextInt(stringArray.length);
                this.addSupplierRFQ(stringArray[n], n5, n2, 0, n4 + 2);
                this.componentDemand.addInventory(n5, -n2);
                continue;
            }
            log.severe("no suppliers for product " + n5);
        }
        this.sendSupplierRFQs();
    }

    protected void handleSupplierOffers(String string, OfferBundle offerBundle) {
        for (int i = offerBundle.size() - 1; i >= 0; --i) {
            if (offerBundle.getQuantity(i) <= 0) continue;
            this.addSupplierOrder(string, offerBundle, i);
        }
        this.sendSupplierOrders();
    }

    protected synchronized void handleSimulationStatus(SimulationStatus simulationStatus) {
        InventoryStatus inventoryStatus = this.getInventoryForNextDay();
        int n = this.getCurrentDate();
        int n2 = n - this.getDaysBeforeVoid() + 2;
        OrderStore orderStore = this.getCustomerOrders();
        Order[] orderArray = orderStore.getActiveOrders();
        if (orderArray != null) {
            for (Order order : orderArray) {
                int n3 = order.getProductID();
                int n4 = order.getDueDate();
                int n5 = order.getQuantity();
                int n6 = inventoryStatus.getInventoryQuantity(n3);
                if (n >= n4 - 1 && n4 >= n2 && this.addDeliveryRequest(order)) continue;
                if (n4 <= n2) {
                    log.info("canceling to late order " + order.getOrderID() + " (dueDate=" + order.getDueDate() + ",date=" + n + ')');
                    this.cancelCustomerOrder(order);
                    continue;
                }
                if (n6 >= n5) {
                    this.reserveInventoryForNextDay(n3, n5);
                    continue;
                }
                if (!this.addProductionRequest(n3, n5 - n6)) continue;
                this.reserveInventoryForNextDay(n3, n6);
            }
        }
        this.sendFactorySchedules();
    }

    private void cancelCustomerOrder(Order order) {
        order.setCanceled();
        int[] nArray = this.getBOMBundle().getComponentsForProductID(order.getProductID());
        if (nArray != null) {
            int n = order.getQuantity();
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                this.componentDemand.addInventory(nArray[i], -n);
            }
        }
    }
}

