/*
 * Decompiled with CFR 0.152.
 */
package com.botbox.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;

public class ArrayQueue
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5791745982858131414L;
    private transient Object[] queueData;
    private transient int first = 0;
    private transient int last = 0;
    private int size = 0;

    public ArrayQueue() {
        this(10);
    }

    public ArrayQueue(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal capacity: " + n);
        }
        this.queueData = new Object[n];
    }

    public void ensureCapacity(int n) {
        int n2 = this.queueData.length;
        if (n2 < n) {
            int n3 = n2 * 3 / 2 + 1;
            this.set(n3 < n ? n : n3);
        }
    }

    private void set(int n) {
        Object[] objectArray = new Object[n];
        this.copy(objectArray);
        this.first = 0;
        this.last = this.size;
        this.queueData = objectArray;
    }

    private void copy(Object[] objectArray) {
        if (this.first < this.last) {
            System.arraycopy(this.queueData, this.first, objectArray, 0, this.size);
        } else if (this.size > 0) {
            int n = this.queueData.length;
            System.arraycopy(this.queueData, this.first, objectArray, 0, n - this.first);
            if (this.last > 0) {
                System.arraycopy(this.queueData, 0, objectArray, n - this.first, this.last);
            }
        }
    }

    public void trimToSize() {
        if (this.size < this.queueData.length) {
            this.set(this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public int indexOf(Object object, int n) {
        if (n < 0 || n >= this.size) {
            return -1;
        }
        int n2 = this.queueData.length;
        int n3 = (this.first + n) % n2;
        if (object == null) {
            while (n < this.size) {
                if (this.queueData[n3] == null) {
                    return n;
                }
                n3 = (n3 + 1) % n2;
                ++n;
            }
        } else {
            while (n < this.size) {
                if (object.equals(this.queueData[n3])) {
                    return n;
                }
                n3 = (n3 + 1) % n2;
                ++n;
            }
        }
        return -1;
    }

    private int lastIndexOf(Object object) {
        if (this.size == 0) {
            return -1;
        }
        int n = this.last;
        int n2 = this.size;
        if (object == null) {
            do {
                n = n > 0 ? --n : this.queueData.length - 1;
                --n2;
                if (this.queueData[n] != null) continue;
                return n2;
            } while (n2 > 0);
        } else {
            do {
                n = n > 0 ? --n : this.queueData.length - 1;
                --n2;
                if (!object.equals(this.queueData[n])) continue;
                return n2;
            } while (n2 > 0);
        }
        return -1;
    }

    public Object get(int n) {
        return this.queueData[this.getIndex(n)];
    }

    public Object set(int n, Object object) {
        n = this.getIndex(n);
        Object object2 = this.queueData[n];
        this.queueData[n] = object;
        return object2;
    }

    public boolean add(Object object) {
        this.ensureCapacity(this.size + 1);
        this.queueData[this.last] = object;
        this.last = (this.last + 1) % this.queueData.length;
        ++this.size;
        return true;
    }

    public void add(int n, Object object) {
        if (n == this.size) {
            this.add(object);
        } else {
            this.ensureCapacity(this.size + 1);
            n = this.getIndex(n);
            if (n == this.first) {
                if (this.first > 0) {
                    --this.first;
                    n = this.first;
                } else {
                    n = this.first = this.queueData.length - 1;
                }
            } else if (n < this.last) {
                System.arraycopy(this.queueData, n, this.queueData, n + 1, this.last - n);
                this.last = (this.last + 1) % this.queueData.length;
            } else {
                System.arraycopy(this.queueData, this.first, this.queueData, this.first - 1, n - this.first);
                --n;
                --this.first;
            }
            this.queueData[n] = object;
            ++this.size;
        }
    }

    public Object remove(int n) {
        n = this.getIndex(n);
        Object object = this.queueData[n];
        if (n == this.first) {
            this.queueData[this.first] = null;
            this.first = (this.first + 1) % this.queueData.length;
        } else if (n < this.last) {
            --this.last;
            if (n < this.last) {
                System.arraycopy(this.queueData, n + 1, this.queueData, n, this.last - n);
            }
            this.queueData[this.last] = null;
        } else if (this.last == 0 && n == this.queueData.length - 1) {
            this.queueData[n] = null;
            this.last = this.queueData.length - 1;
        } else {
            System.arraycopy(this.queueData, this.first, this.queueData, this.first + 1, n - this.first);
            this.queueData[this.first++] = null;
        }
        --this.size;
        return object;
    }

    public void clear() {
        int n = this.queueData.length;
        int n2 = this.first;
        for (int i = 0; i < this.size; ++i) {
            this.queueData[n2] = null;
            n2 = (n2 + 1) % n;
        }
        this.size = 0;
        this.last = 0;
        this.first = 0;
    }

    public Object clone() {
        try {
            ArrayQueue arrayQueue = (ArrayQueue)super.clone();
            arrayQueue.set(arrayQueue.size);
            return arrayQueue;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        this.copy(objectArray);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        this.copy(objectArray);
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    private int getIndex(int n) {
        if (n >= 0 && n < this.size) {
            return (this.first + n) % this.queueData.length;
        }
        throw new IndexOutOfBoundsException("index=" + n + " size=" + this.size);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.queueData.length;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(n);
        int n2 = this.first;
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(this.queueData[n2]);
            n2 = (n2 + 1) % n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.queueData = new Object[objectInputStream.readInt()];
        for (int i = 0; i < this.size; ++i) {
            this.queueData[i] = objectInputStream.readObject();
        }
        this.first = 0;
        this.last = this.size;
    }
}

