/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class BarDiagram
extends JComponent {
    private static final double PI2 = 1.570796;
    private int[] data;
    private int maxData;
    private int minData;
    private double factor;
    private int xspace;
    private int xfill;
    private boolean rescale = false;
    private int sizeX;
    private int sizeY;
    private int lowerY;
    private Color barColor;
    private Color leftColor;
    private Color rightColor;
    private Color[] allColors;
    private boolean isShowingValue = false;
    private Color inValueColor = Color.white;
    private Color outValueColor = Color.black;
    private Insets insets;
    private String[] names;

    public BarDiagram() {
        this.setOpaque(true);
        this.setBackground(Color.white);
    }

    public void setToolTipVisible(boolean bl) {
        this.setToolTipText(bl ? "" : null);
    }

    public void setNames(String[] stringArray) {
        this.names = stringArray;
    }

    public void setData(int[] nArray) {
        this.maxData = Integer.MIN_VALUE;
        this.minData = Integer.MAX_VALUE;
        if (nArray != null) {
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                if (this.maxData < nArray[i]) {
                    this.maxData = nArray[i];
                }
                if (this.minData <= nArray[i]) continue;
                this.minData = nArray[i];
            }
        }
        if (this.minData > 0) {
            this.minData = 0;
        }
        if (this.maxData < this.minData) {
            this.maxData = this.minData;
        }
        this.data = nArray;
        this.rescale = true;
        this.setupColors();
        this.repaint();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n;
        if (this.xspace == 0) {
            return null;
        }
        String[] stringArray = this.names;
        int[] nArray = this.data;
        int n2 = mouseEvent.getX() / this.xspace;
        int n3 = stringArray == null ? 0 : stringArray.length;
        int n4 = n = nArray == null ? 0 : nArray.length;
        if (n >= n3) {
            if (n2 >= n) {
                n2 = n - 1;
            }
        } else if (n2 >= n3) {
            n2 = n3 - 1;
        }
        if (n2 < 0) {
            return null;
        }
        String string = n2 >= n3 ? "Value =" : stringArray[n2];
        int n5 = n2 >= n ? 0 : nArray[n2];
        return string + ' ' + n5;
    }

    public void setBarColor(Color color) {
        this.barColor = color;
        this.leftColor = null;
        this.rightColor = null;
        this.allColors = null;
    }

    public void setBarColors(Color color, Color color2) {
        this.leftColor = color;
        this.rightColor = color2;
        this.allColors = null;
        this.setupColors();
    }

    private void setupColors() {
        if (this.leftColor != null && this.data != null) {
            if (this.allColors != null && this.allColors.length == this.data.length) {
                return;
            }
            float f = this.data.length;
            float f2 = (float)this.leftColor.getRed() / f;
            float f3 = (float)this.rightColor.getRed() / f;
            float f4 = (float)this.leftColor.getGreen() / f;
            float f5 = (float)this.rightColor.getGreen() / f;
            float f6 = (float)this.leftColor.getBlue() / f;
            float f7 = (float)this.rightColor.getBlue() / f;
            this.allColors = new Color[this.data.length];
            int n = this.data.length;
            for (int i = 0; i < n; ++i) {
                this.allColors[i] = new Color((int)(f2 * (float)(n - i) + f3 * (float)i), (int)(f4 * (float)(n - i) + f5 * (float)i), (int)(f6 * (float)(n - i) + f7 * (float)i));
            }
        }
    }

    public boolean isShowingValue() {
        return this.isShowingValue;
    }

    public void setShowingValue(boolean bl) {
        if (this.isShowingValue != bl) {
            this.isShowingValue = bl;
            this.repaint();
        }
    }

    public void setValueColor(Color color) {
        this.outValueColor = this.inValueColor = color;
    }

    public void setValueColors(Color color, Color color2) {
        this.inValueColor = color;
        this.outValueColor = color2;
    }

    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        Color color = graphics.getColor();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n3, n4);
        }
        this.insets = this.getInsets(this.insets);
        int n5 = this.insets.left;
        int n6 = this.insets.top;
        n3 = n3 - this.insets.left - this.insets.right;
        n4 = n4 - this.insets.top - this.insets.bottom;
        if (n3 != this.sizeX || n4 != this.sizeY || this.rescale) {
            this.rescale = false;
            this.sizeY = n4;
            this.sizeX = n3;
            this.lowerY = this.sizeY - 3;
            this.factor = this.minData == this.maxData ? 1.0 : (double)(this.sizeY - 15) / (double)(this.maxData - this.minData);
            this.xspace = this.data == null ? 2 : this.sizeX / this.data.length;
            this.xfill = this.xspace - 2;
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n5, n6 + this.lowerY, n5 + this.sizeX, n6 + this.lowerY);
        if (this.data == null) {
            graphics.setColor(color);
            return;
        }
        int[] nArray = this.data;
        if (this.allColors == null) {
            if (this.barColor != null) {
                graphics.setColor(this.barColor);
            } else {
                graphics.setColor(this.getForeground());
            }
        }
        int n7 = nArray.length;
        for (n2 = 0; n2 < n7; ++n2) {
            n = (int)(this.factor * (double)nArray[n2]);
            if (this.allColors != null) {
                graphics.setColor(this.allColors[n2]);
            }
            graphics.fillRect(n5 + n2 * this.xspace, n6 + this.lowerY - n, this.xfill, n);
        }
        graphics.setColor(Color.black);
        n7 = nArray.length;
        for (n2 = 0; n2 < n7; ++n2) {
            n = (int)(this.factor * (double)nArray[n2]);
            graphics.drawRect(n5 + n2 * this.xspace, n6 + this.lowerY - n, this.xfill, n);
        }
        if (this.isShowingValue && graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.rotate(-1.570796);
            n = nArray.length;
            for (n7 = 0; n7 < n; ++n7) {
                if (nArray[n7] <= 0) continue;
                int n8 = (int)(this.factor * (double)nArray[n7]) - n6 - this.lowerY;
                if (n8 > -50) {
                    n8 = -80;
                    graphics.setColor(this.inValueColor);
                } else {
                    graphics.setColor(this.outValueColor);
                }
                graphics2D.drawString(Integer.toString(nArray[n7]), n8, n5 + n7 * this.xspace + 4 + this.xspace / 2);
            }
            graphics2D.rotate(1.570796);
        }
        graphics.setColor(color);
    }

    public static void main(String[] stringArray) throws Exception {
        JFrame jFrame = new JFrame("test");
        jFrame.setDefaultCloseOperation(3);
        BarDiagram barDiagram = new BarDiagram();
        barDiagram.setBarColors(Color.red, Color.green);
        barDiagram.setShowingValue(true);
        barDiagram.setData(new int[]{12, 42, 12, 21, 55, 3, 15, 12, 42, 12, 21, 55, 3, 15});
        jFrame.setSize(800, 200);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)barDiagram, "Center");
        jFrame.setVisible(true);
        for (int i = 0; i < 10; ++i) {
            barDiagram.setData(new int[]{12, 42, 12, 21, 55, 3, 15, 12, 42, 12, 21, 55, 13, 15});
            Thread.sleep(500L);
            barDiagram.setData(new int[]{12, 24, 21, 12, 12, 21, 55, 3, 15, 32, 55, 23, 33, 15});
            Thread.sleep(500L);
        }
    }
}

