/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.gui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class DotDiagram
extends JComponent {
    public static final int NORMAL = 0;
    public static final int ADDITIVE = 1;
    public static final int FILLED_ADDITIVE = 2;
    private int[][] data;
    private int[] dataLen;
    private int[] start;
    private int[] maxData;
    private int[] minData;
    private int totMax;
    private int totMin;
    private boolean lockMinMax = false;
    private int maxDataLen;
    private double factor;
    private int[] constantY;
    private Color[] constantColor;
    private int sizeX;
    private int sizeY;
    private int lowerY;
    private double xspace;
    private int ySpacing = 0;
    private int xSpacing = 0;
    private boolean rescale = false;
    private boolean gridVisible = false;
    private String yLabel = null;
    private String xLabel = null;
    private boolean isAdditive = false;
    private boolean isFilled = false;
    private Insets insets;
    private Color[] lineColor;

    public DotDiagram(int n) {
        this(n, 0);
    }

    public DotDiagram(int n, int n2) {
        this.data = new int[n][];
        this.lineColor = new Color[n];
        this.dataLen = new int[n];
        this.start = new int[n];
        this.maxData = new int[n];
        this.minData = new int[n];
        for (int i = 0; i < n; ++i) {
            this.lineColor[i] = Color.black;
        }
        this.setOpaque(true);
        this.isFilled = n2 == 2;
        this.isAdditive = this.isFilled || n2 == 1;
    }

    public void setShowGrid(boolean bl) {
        this.gridVisible = bl;
    }

    public void setGridYSpacing(int n) {
        this.ySpacing = n;
    }

    public void setYLabel(String string) {
        this.yLabel = string;
    }

    public void setXLabel(String string) {
        this.xLabel = string;
    }

    public void setName(int n, String string) {
    }

    public void setToolTipVisible(boolean bl) {
    }

    public void addConstant(Color color, int n) {
        int n2;
        if (this.constantY == null) {
            n2 = 0;
            this.constantY = new int[1];
            this.constantColor = new Color[1];
        } else {
            n2 = this.constantY.length;
            int[] nArray = new int[n2 + 1];
            Color[] colorArray = new Color[n2 + 1];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.constantY[i];
                colorArray[i] = this.constantColor[i];
            }
            this.constantY = nArray;
            this.constantColor = colorArray;
        }
        this.constantY[n2] = n;
        this.constantColor[n2] = color == null ? Color.black : color;
        this.rescale = true;
        this.repaint();
    }

    public void setMinMax(int n, int n2) {
        this.totMax = n2;
        this.totMin = n;
        this.lockMinMax = true;
        this.rescale = true;
    }

    public void setData(int n, int[] nArray, int n2, int n3) {
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MAX_VALUE;
        if (n3 > 0) {
            int n6 = nArray.length;
            int n7 = n2 + n3;
            for (int i = n2; i < n7; ++i) {
                int n8 = nArray[i % n6];
                if (n4 < n8) {
                    n4 = n8;
                }
                if (n5 <= n8) continue;
                n5 = n8;
            }
        }
        if (n5 > 0) {
            n5 = 0;
        }
        if (n4 < n5) {
            n4 = n5;
        }
        this.dataLen[n] = n3;
        this.start[n] = n2;
        this.data[n] = nArray;
        this.maxData[n] = n4;
        this.minData[n] = n5;
        this.rescale = true;
        this.repaint();
    }

    public void setDotColor(int n, Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.lineColor[n] = color;
        if (this.dataLen[n] > 0) {
            this.repaint();
        }
    }

    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n42;
        int n5;
        int n6;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics2D.getColor();
        int n7 = this.getWidth();
        int n8 = this.getHeight();
        int n9 = 0;
        if (this.yLabel != null || this.xLabel != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            n9 = fontMetrics.stringWidth(this.yLabel);
        }
        if (this.isOpaque()) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n7, n8);
        }
        this.insets = this.getInsets(this.insets);
        int n10 = this.yLabel != null ? 12 * n7 / 200 : 0;
        int n11 = this.insets.left + n10;
        int n12 = this.insets.top;
        n7 = n7 - this.insets.left - this.insets.right - n10;
        n8 = n8 - this.insets.top - this.insets.bottom;
        if (this.rescale || n7 != this.sizeX || n8 != this.sizeY) {
            if (this.rescale) {
                this.rescale = false;
                this.maxDataLen = 0;
                if (this.lockMinMax) {
                    n6 = this.data.length;
                    for (n5 = 0; n5 < n6; ++n5) {
                        if (this.dataLen[n5] <= this.maxDataLen) continue;
                        this.maxDataLen = this.dataLen[n5];
                    }
                } else {
                    this.totMin = Integer.MAX_VALUE;
                    this.totMax = Integer.MIN_VALUE;
                    if (this.constantY != null) {
                        for (int n42 : this.constantY) {
                            if (n42 < this.totMin) {
                                this.totMin = n42;
                            }
                            if (n42 <= this.totMax) continue;
                            this.totMax = n42;
                        }
                    }
                    n5 = 0;
                    n42 = this.data.length;
                    for (n6 = 0; n6 < n42; ++n6) {
                        if (this.dataLen[n6] <= 0) continue;
                        int n13 = this.minData[n6];
                        n3 = this.maxData[n6];
                        if (n13 < this.totMin) {
                            this.totMin = n13;
                        }
                        if (n3 > this.totMax) {
                            this.totMax = n3;
                        }
                        if (this.dataLen[n6] > this.maxDataLen) {
                            this.maxDataLen = this.dataLen[n6];
                        }
                        n5 += n3;
                    }
                    if (this.isAdditive && n5 > this.totMax) {
                        this.totMax = n5;
                    }
                    if (this.totMin > 0) {
                        this.totMin = 0;
                    }
                    if (this.totMax < this.totMin) {
                        this.totMax = this.totMin;
                    }
                }
            }
            this.sizeY = n8;
            this.sizeX = n7 - 2;
            this.factor = this.totMax < 0 ? (double)(this.sizeY - 15) / (double)(0 - this.totMin) : (this.totMax == this.totMin ? 1.0 : (double)(this.sizeY - 15) / (double)(this.totMax - this.totMin));
            this.lowerY = this.sizeY - 5;
            this.xspace = this.maxDataLen == 0 ? 1.0 : (double)this.sizeX / (double)this.maxDataLen;
        }
        n11 += 2;
        n5 = n12 + this.lowerY - (int)(this.factor * (double)(0 - this.totMin));
        if (this.gridVisible) {
            double d;
            graphics2D.setColor(Color.lightGray);
            n42 = 10;
            for (n6 = 0; n6 < n42; ++n6) {
                graphics2D.drawLine(n11 + n6 * this.sizeX / 10, n12, n11 + n6 * this.sizeX / 10, n12 + this.sizeY - 1);
            }
            n6 = n5 - n12;
            n42 = n5 - (n12 + this.sizeY);
            double d2 = (double)this.ySpacing * this.factor == 0.0 ? (double)this.sizeY / 10.0 : this.factor * (double)this.ySpacing;
            for (d = 0.0; d < (double)n6; d += d2) {
                graphics2D.drawLine(n11 + 1, (int)((double)n5 - d), n11 + this.sizeX, (int)((double)n5 - d));
            }
            for (d = 0.0; d > (double)n42; d -= d2) {
                graphics2D.drawLine(n11 + 1, (int)((double)n5 - d), n11 + this.sizeX, (int)((double)n5 - d));
            }
        }
        if (this.isAdditive) {
            if (this.isFilled) {
                n6 = (int)(this.xspace + 1.0);
                int n14 = this.maxDataLen;
                for (n42 = 0; n42 < n14; ++n42) {
                    n3 = n5;
                    int n15 = this.data.length;
                    for (int i = 0; i < n15; ++i) {
                        int[] nArray;
                        if (this.dataLen[i] <= n42 || (n2 = (int)(this.factor * (double)(nArray = this.data[i])[(n = this.start[i] + n42) % nArray.length])) <= 0) continue;
                        graphics2D.setColor(this.lineColor[i]);
                        graphics2D.fillRect(n11 + (int)((double)n42 * this.xspace), n3 - n2, n6, n2);
                        n3 -= n2;
                    }
                }
            } else {
                n42 = this.maxDataLen;
                for (n6 = 0; n6 < n42; ++n6) {
                    int n16 = n5;
                    int n17 = this.data.length;
                    for (n3 = 0; n3 < n17; ++n3) {
                        int n18;
                        int[] nArray;
                        if (this.dataLen[n3] <= n6 || (n = (int)(this.factor * (double)(nArray = this.data[n3])[(n18 = this.start[n3] + n6) % nArray.length])) <= 0) continue;
                        graphics2D.setColor(this.lineColor[n3]);
                        graphics2D.drawLine(n11 + (int)((double)(n6 - 1) * this.xspace), n16 - n, n11 + (int)((double)n6 * this.xspace), n16 - n);
                        n16 -= n;
                    }
                }
            }
        } else {
            n42 = this.data.length;
            for (n6 = 0; n6 < n42; ++n6) {
                if (this.dataLen[n6] <= 0) continue;
                int[] nArray = this.data[n6];
                n3 = nArray.length;
                int n19 = this.start[n6];
                int n20 = (int)(this.factor * (double)(nArray[n19 % n3] - this.totMin));
                graphics2D.setColor(this.lineColor[n6]);
                n = this.dataLen[n6];
                for (int i = 1; i < n; ++i) {
                    n2 = n19 + i;
                    int n21 = (int)(this.factor * (double)(nArray[n2 % n3] - this.totMin));
                    graphics2D.drawLine(n11 + (int)((double)(i - 1) * this.xspace), n12 + this.lowerY - n20, n11 + (int)((double)i * this.xspace), n12 + this.lowerY - n21);
                    n20 = n21;
                }
            }
        }
        if (this.constantY != null) {
            n42 = this.constantY.length;
            for (n6 = 0; n6 < n42; ++n6) {
                int n22 = n12 + this.lowerY - (int)(this.factor * (double)(this.constantY[n6] - this.totMin));
                graphics2D.setColor(this.constantColor[n6]);
                graphics2D.drawLine(n11, n22, n11 + this.sizeX, n22);
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(n11 -= 2, n5, n11 + this.sizeX, n5);
        graphics2D.drawLine(n11 + 1, n12, n11 + 1, n12 + this.sizeY - 1);
        if (this.yLabel != null) {
            graphics2D.rotate(-1.57075);
            graphics2D.scale((double)n8 / 200.0, (double)n7 / 200.0);
            graphics2D.drawString(this.yLabel, -100 - n9 / 2, 10);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        JFrame jFrame = new JFrame("DotDiagram - Test");
        int[] nArray = new int[100];
        int[] nArray2 = new int[100];
        int[] nArray3 = new int[100];
        boolean bl = true;
        int n = 100;
        int n2 = 50;
        int n3 = 0;
        int n4 = bl ? -10 : 0;
        for (int i = 0; i < 60; ++i) {
            nArray[i] = n += (int)((double)n4 + 20.0 * Math.random());
            nArray2[i] = n2 += (int)((double)n4 + 20.0 * Math.random());
            nArray3[i] = n3 += (int)((double)n4 + 20.0 * Math.random());
        }
        DotDiagram dotDiagram = DotDiagram.setupDiagram(10, nArray, nArray2, nArray3, 0);
        DotDiagram dotDiagram2 = DotDiagram.setupDiagram(10, nArray, nArray2, nArray3, 1);
        DotDiagram dotDiagram3 = DotDiagram.setupDiagram(10, nArray, nArray2, nArray3, 2);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(600, 200);
        jFrame.getContentPane().setLayout(new GridLayout(0, 3));
        jFrame.getContentPane().add(dotDiagram);
        jFrame.getContentPane().add(dotDiagram2);
        jFrame.getContentPane().add(dotDiagram3);
        jFrame.setVisible(true);
        for (int i = 0; i < 20000; ++i) {
            Thread.sleep(100L);
            n2 += (int)(5.0 - 10.0 * Math.random());
            n3 += (int)(5.0 - 10.0 * Math.random());
            if ((n += (int)(5.0 - 10.0 * Math.random())) < 0) {
                n = 0;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            nArray[(60 + i) % nArray.length] = n;
            nArray2[(60 + i) % nArray2.length] = n2;
            nArray3[(60 + i) % nArray3.length] = n3;
            dotDiagram.setData(0, nArray, i % nArray.length, 60);
            dotDiagram.setData(1, nArray2, i % nArray2.length, 60);
            dotDiagram.setData(2, nArray3, i % nArray3.length, 60);
            dotDiagram2.setData(0, nArray, i % nArray.length, 60);
            dotDiagram2.setData(1, nArray2, i % nArray2.length, 60);
            dotDiagram2.setData(2, nArray3, i % nArray3.length, 60);
            dotDiagram3.setData(0, nArray, i % nArray.length, 60);
            dotDiagram3.setData(1, nArray2, i % nArray2.length, 60);
            dotDiagram3.setData(2, nArray3, i % nArray3.length, 60);
        }
    }

    private static DotDiagram setupDiagram(int n, int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        DotDiagram dotDiagram = new DotDiagram(n, n2);
        dotDiagram.setDotColor(0, Color.red);
        dotDiagram.setDotColor(1, Color.green);
        dotDiagram.setDotColor(2, Color.blue);
        dotDiagram.addConstant(Color.yellow, 100);
        dotDiagram.setShowGrid(true);
        dotDiagram.setYLabel("The Y-Axis (" + (n2 == 0 ? "normal" : "additive") + ')');
        dotDiagram.setData(0, nArray, 0, 60);
        dotDiagram.setData(1, nArray2, 0, 60);
        dotDiagram.setData(2, nArray3, 0, 60);
        return dotDiagram;
    }
}

