/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.gui;

import javax.swing.AbstractListModel;

public class MessageModel
extends AbstractListModel {
    public static final int NONE = 0;
    public static final int WARNING = 1;
    private String[] messages;
    private int[] messageFlag;
    private int messagePos = 0;
    private int size = 0;

    public MessageModel(int n) {
        this.messages = new String[n];
        this.messageFlag = new int[n];
    }

    public void addMessage(String string) {
        this.addMessage(string, 0);
    }

    public void addMessage(String string, int n) {
        if (this.size < this.messages.length) {
            int n2 = this.size++;
            this.messageFlag[n2] = n;
            this.messages[n2] = string;
            this.fireIntervalAdded(this, n2, n2);
        } else {
            this.messages[this.messagePos] = string;
            this.messageFlag[this.messagePos] = n;
            this.messagePos = (this.messagePos + 1) % this.size;
            this.fireContentsChanged(this, 0, this.size);
        }
    }

    public void clear() {
        if (this.size > 0) {
            int n = this.size;
            this.fireIntervalRemoved(this, 0, this.size - 1);
            this.size = 0;
            for (int i = 0; i < n; ++i) {
                this.messages[i] = null;
            }
        }
    }

    public Object getElementAt(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.size);
        }
        n = (this.messagePos + n) % this.size;
        return this.messages[n];
    }

    public int getFlagAt(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.size);
        }
        n = (this.messagePos + n) % this.size;
        return this.messageFlag[n];
    }

    public int getSize() {
        return this.size;
    }
}

